/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool;

import de.bixilon.kutil.time.TimeUtil;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010'\u001a\u00020(R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0012\u001a\u0004\u0018\u00010\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000f\"\u0004\b$\u0010\u0015\u00a8\u0006)"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPoolRunnable;", "", "priority", "", "interruptable", "", "forcePool", "runnable", "Ljava/lang/Runnable;", "(IZZLjava/lang/Runnable;)V", "creation", "", "getCreation", "()J", "getForcePool", "()Z", "interruptLock", "Ljava/util/concurrent/locks/ReentrantLock;", "value", "getInterruptable", "setInterruptable", "(Z)V", "getPriority", "()I", "getRunnable", "()Ljava/lang/Runnable;", "setRunnable", "(Ljava/lang/Runnable;)V", "Ljava/lang/Thread;", "thread", "getThread", "()Ljava/lang/Thread;", "setThread", "(Ljava/lang/Thread;)V", "wasInterrupted", "getWasInterrupted", "setWasInterrupted", "compareTo", "other", "interrupt", "", "kutil"})
public final class ThreadPoolRunnable
implements Comparable<ThreadPoolRunnable> {
    private final int priority;
    private final boolean forcePool;
    @Nullable
    private Runnable runnable;
    @NotNull
    private final ReentrantLock interruptLock;
    private final long creation;
    private boolean wasInterrupted;
    @Nullable
    private Thread thread;
    private boolean interruptable;

    public ThreadPoolRunnable(int priority, boolean interruptable, boolean forcePool, @Nullable Runnable runnable) {
        this.priority = priority;
        this.forcePool = forcePool;
        this.runnable = runnable;
        this.interruptLock = new ReentrantLock();
        this.creation = TimeUtil.INSTANCE.nanos();
        this.interruptable = interruptable;
        if (this.priority == 1 || this.priority == -1) {
            throw new IllegalArgumentException("Priority of 1 or -1 is unsupported!");
        }
    }

    public /* synthetic */ ThreadPoolRunnable(int n, boolean bl, boolean bl2, Runnable runnable, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = true;
        }
        if ((n2 & 8) != 0) {
            runnable = null;
        }
        this(n, bl, bl2, runnable);
    }

    public final int getPriority() {
        return this.priority;
    }

    public final boolean getForcePool() {
        return this.forcePool;
    }

    @Nullable
    public final Runnable getRunnable() {
        return this.runnable;
    }

    public final void setRunnable(@Nullable Runnable runnable) {
        this.runnable = runnable;
    }

    public final long getCreation() {
        return this.creation;
    }

    public final boolean getWasInterrupted() {
        return this.wasInterrupted;
    }

    public final void setWasInterrupted(boolean bl) {
        this.wasInterrupted = bl;
    }

    @Nullable
    public final Thread getThread() {
        return this.thread;
    }

    public final void setThread(@Nullable Thread value) {
        if (value == null) {
            Thread.interrupted();
        }
        this.interruptLock.lock();
        this.thread = value;
        this.interruptLock.unlock();
    }

    public final boolean getInterruptable() {
        return this.interruptable;
    }

    public final void setInterruptable(boolean value) {
        this.interruptLock.lock();
        if (this.interruptable == value) {
            this.interruptLock.unlock();
            return;
        }
        this.interruptable = value;
        this.interruptLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void interrupt() {
        this.interruptLock.lock();
        try {
            Thread thread;
            block8: {
                block7: {
                    thread = this.thread;
                    if (!this.interruptable || thread == null) break block7;
                    if (!this.wasInterrupted) break block8;
                }
                return;
            }
            thread.interrupt();
            this.wasInterrupted = true;
        }
        finally {
            this.interruptLock.unlock();
        }
    }

    @Override
    public int compareTo(@NotNull ThreadPoolRunnable other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int difference = other.priority - this.priority;
        if (difference != 0) {
            return difference;
        }
        if (this.creation - other.creation < 0L) {
            return -1;
        }
        return 1;
    }

    public ThreadPoolRunnable() {
        this(0, false, false, null, 15, null);
    }
}

