/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.worker.unconditional;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.worker.WorkerStates;
import de.bixilon.kutil.concurrent.worker.unconditional.UnconditionalTask;
import de.bixilon.kutil.concurrent.worker.unconditional.UnconditionalWorker;
import de.bixilon.kutil.latch.CountUpAndDownLatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J-\u0010\u0015\u001a\u00020\u00162%\u0010\u0017\u001a!\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00160\u0018j\u0002`\u001dJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0013J0\u0010\u001f\u001a\u00020\u00162%\u0010\u0017\u001a!\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00160\u0018j\u0002`\u001dH\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0013H\u0086\u0002J\u0006\u0010 \u001a\u00020\u0016J\u0012\u0010!\u001a\u00020\u00162\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006#"}, d2={"Lde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalWorker;", "", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "forcePool", "", "threadSafe", "(Lde/bixilon/kutil/concurrent/pool/ThreadPool;ZZ)V", "getForcePool", "()Z", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "<set-?>", "Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "state", "getState", "()Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "tasks", "", "Lde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalTask;", "getThreadSafe", "add", "", "executor", "Lkotlin/Function1;", "Lde/bixilon/kutil/latch/CountUpAndDownLatch;", "Lkotlin/ParameterName;", "name", "progress", "Lde/bixilon/kutil/concurrent/worker/WorkerExecutor;", "task", "plusAssign", "reset", "work", "latch", "kutil"})
public final class UnconditionalWorker {
    @NotNull
    private final ThreadPool pool;
    private final boolean forcePool;
    private final boolean threadSafe;
    @NotNull
    private final List<UnconditionalTask> tasks;
    @NotNull
    private WorkerStates state;

    public UnconditionalWorker(@NotNull ThreadPool pool, boolean forcePool, boolean threadSafe) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.pool = pool;
        this.forcePool = forcePool;
        this.threadSafe = threadSafe;
        if (this.threadSafe) {
            CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
            UnconditionalTask[] values$iv = new UnconditionalTask[]{};
            boolean $i$f$synchronizedListOf = false;
            List list2 = Collections.synchronizedList(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values$iv, values$iv.length)));
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"synchronizedList(mutableListOf(*values))");
        } else {
            list = new ArrayList();
        }
        this.tasks = list;
        this.state = WorkerStates.PREPARING;
    }

    public /* synthetic */ UnconditionalWorker(ThreadPool threadPool, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(threadPool, bl, bl2);
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final boolean getForcePool() {
        return this.forcePool;
    }

    public final boolean getThreadSafe() {
        return this.threadSafe;
    }

    @NotNull
    public final WorkerStates getState() {
        return this.state;
    }

    public final void add(@NotNull UnconditionalTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.state != WorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
        }
        ((Collection)this.tasks).add(task);
    }

    public final void plusAssign(@NotNull UnconditionalTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.add(task);
    }

    public final void add(@NotNull Function1<? super CountUpAndDownLatch, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.add(new UnconditionalTask(0, executor, 1, null));
    }

    public final void plusAssign(@NotNull Function1<? super CountUpAndDownLatch, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.add(executor);
    }

    public final void work(@Nullable CountUpAndDownLatch latch) {
        CountUpAndDownLatch countUpAndDownLatch;
        if (this.state != WorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
        }
        this.state = WorkerStates.WORKING;
        CountUpAndDownLatch countUpAndDownLatch2 = latch;
        if (countUpAndDownLatch2 != null) {
            CountUpAndDownLatch it = countUpAndDownLatch2;
            boolean bl = false;
            countUpAndDownLatch = new CountUpAndDownLatch(1, it);
        } else {
            countUpAndDownLatch = new CountUpAndDownLatch(1, null, 2, null);
        }
        CountUpAndDownLatch innerLatch = countUpAndDownLatch;
        CollectionsKt.sortWith(this.tasks, (arg_0, arg_1) -> UnconditionalWorker.work$lambda$1(work.1.INSTANCE, arg_0, arg_1));
        innerLatch.plus(this.tasks.size());
        CountUpAndDownLatch running = new CountUpAndDownLatch(0, null, 2, null);
        for (UnconditionalTask task : this.tasks) {
            running.inc();
            if (!this.forcePool && (this.pool.isBusy() || this.pool.isBacklog())) {
                UnconditionalWorker.work$run(innerLatch, running, task.getExecutor());
            } else {
                this.pool.plusAssign(new ThreadPoolRunnable(task.getPriority(), false, false, () -> UnconditionalWorker.work$lambda$2(task, innerLatch, running), 6, null));
            }
            CountUpAndDownLatch.waitIfGreater$default(running, this.pool.getThreadCount(), 0L, 2, null);
        }
        innerLatch.dec();
        CountUpAndDownLatch.await$default(innerLatch, 0L, 1, null);
        this.state = WorkerStates.FINISHED;
    }

    public static /* synthetic */ void work$default(UnconditionalWorker unconditionalWorker, CountUpAndDownLatch countUpAndDownLatch, int n, Object object) {
        if ((n & 1) != 0) {
            countUpAndDownLatch = null;
        }
        unconditionalWorker.work(countUpAndDownLatch);
    }

    public final void reset() {
        this.tasks.clear();
        this.state = WorkerStates.PREPARING;
    }

    private static final int work$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final void work$run(CountUpAndDownLatch innerLatch, CountUpAndDownLatch running, Function1<? super CountUpAndDownLatch, Unit> executor) {
        try {
            executor.invoke((Object)innerLatch);
        }
        catch (Throwable error) {
            error.printStackTrace();
        }
        innerLatch.dec();
        running.dec();
    }

    private static final void work$lambda$2(UnconditionalTask $task, CountUpAndDownLatch $innerLatch, CountUpAndDownLatch $running) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$innerLatch, (String)"$innerLatch");
        Intrinsics.checkNotNullParameter((Object)$running, (String)"$running");
        UnconditionalWorker.work$run($innerLatch, $running, $task.getExecutor());
    }

    public UnconditionalWorker() {
        this(null, false, false, 7, null);
    }
}

