/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.file;

import de.bixilon.kutil.stream.InputStreamUtil;
import de.bixilon.kutil.string.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004J\n\u0010\u000f\u001a\u00020\u0010*\u00020\bJ\u0014\u0010\u0011\u001a\u00020\u0004*\u00020\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0015\u0010\u0007\u001a\u00020\u0004*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lde/bixilon/kutil/file/FileUtil;", "", "()V", "LINE_SEPARATOR", "", "getLINE_SEPARATOR", "()Ljava/lang/String;", "slashPath", "Ljava/io/File;", "getSlashPath", "(Ljava/io/File;)Ljava/lang/String;", "safeSaveToFile", "", "destination", "content", "createParent", "", "read", "charset", "Ljava/nio/charset/Charset;", "kutil"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();
    @NotNull
    private static final String LINE_SEPARATOR;

    private FileUtil() {
    }

    @NotNull
    public final String getLINE_SEPARATOR() {
        return LINE_SEPARATOR;
    }

    public final void safeSaveToFile(@NotNull File destination, @NotNull String content) {
        FileWriter fileWriter;
        File tempFile;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File parent = destination.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IOException("Could not create folder: " + parent.getPath());
            }
        }
        if ((tempFile = new File(destination.getPath() + ".tmp")).exists() && !tempFile.delete()) {
            throw new IOException("Could not delete " + tempFile + '!');
        }
        FileWriter $this$safeSaveToFile_u24lambda_u240 = fileWriter = new FileWriter(tempFile);
        boolean bl = false;
        $this$safeSaveToFile_u24lambda_u240.write(content);
        $this$safeSaveToFile_u24lambda_u240.close();
        if (destination.exists() && !destination.delete()) {
            throw new IOException("Could not delete " + destination + '!');
        }
        if (!tempFile.renameTo(destination)) {
            throw new IOException("Could not move " + tempFile + " to " + destination + '!');
        }
    }

    @NotNull
    public final String getSlashPath(@NotNull File $this$slashPath) {
        Intrinsics.checkNotNullParameter((Object)$this$slashPath, (String)"<this>");
        String string = $this$slashPath.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"absolutePath");
        return StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String read(@NotNull File $this$read, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$read, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        return InputStreamUtil.INSTANCE.readAsString(new FileInputStream($this$read), charset);
    }

    public static /* synthetic */ String read$default(FileUtil fileUtil, File file, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            Charset charset2 = StringUtil.INSTANCE.getDEFAULT_CHARSET();
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"StringUtil.DEFAULT_CHARSET");
            charset = charset2;
        }
        return fileUtil.read(file, charset);
    }

    public final boolean createParent(@NotNull File $this$createParent) {
        Intrinsics.checkNotNullParameter((Object)$this$createParent, (String)"<this>");
        File parent = $this$createParent.getParentFile();
        if (parent.exists()) {
            return false;
        }
        parent.mkdirs();
        return true;
    }

    static {
        String string = System.getProperty("line.separator");
        if (string == null) {
            string = "\n";
        }
        LINE_SEPARATOR = string;
    }
}

