/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.latch;

import de.bixilon.kutil.time.TimeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0018\u001a\u00020\r2\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\r2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\r2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\rJ\t\u0010\u001f\u001a\u00020\u0000H\u0086\u0002J\t\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\r\u0010\u0011\u001a\u00020\rH\u0003\u00a2\u0006\u0002\b\"J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0003J\u0017\u0010$\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0086\u0002J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\r2\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010)\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u001aR\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\tR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00038F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\t\u00a8\u0006*"}, d2={"Lde/bixilon/kutil/latch/CountUpAndDownLatch;", "", "count", "", "parent", "(ILde/bixilon/kutil/latch/CountUpAndDownLatch;)V", "value", "_count", "set_count", "(I)V", "callbacks", "", "Lkotlin/Function0;", "", "getCount", "()I", "setCount", "notify", "Ljava/lang/Object;", "getParent", "()Lde/bixilon/kutil/latch/CountUpAndDownLatch;", "total", "getTotal", "setTotal", "await", "timeout", "", "awaitOrChange", "awaitWithChange", "countDown", "countUp", "dec", "inc", "minus", "Notify2", "plus", "plusAssign", "callback", "toString", "", "waitForChange", "waitIfGreater", "kutil"})
public final class CountUpAndDownLatch {
    @Nullable
    private final CountUpAndDownLatch parent;
    @NotNull
    private final Set<Function0<Unit>> callbacks;
    @NotNull
    private final Object notify;
    private int _count;
    private int total;

    @JvmOverloads
    public CountUpAndDownLatch(int count, @Nullable CountUpAndDownLatch parent) {
        this.parent = parent;
        this.callbacks = new LinkedHashSet();
        this.notify = new Object();
        if (!(this.parent != this)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.setCount(this.getCount() + count);
    }

    public /* synthetic */ CountUpAndDownLatch(int n, CountUpAndDownLatch countUpAndDownLatch, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            countUpAndDownLatch = null;
        }
        this(n, countUpAndDownLatch);
    }

    @Nullable
    public final CountUpAndDownLatch getParent() {
        return this.parent;
    }

    private final void set_count(int value) {
        int diff = value - this._count;
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "Can not set negative count (previous=" + this._count + ", value=" + value + ')';
            throw new IllegalStateException(string.toString());
        }
        if (diff > 0) {
            this.setTotal(this.getTotal() + diff);
        }
        this._count = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCount() {
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            int n = this._count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCount(int value) {
        block3: {
            int diff = 0;
            Object object = this.notify;
            synchronized (object) {
                boolean bl = false;
                diff = value - this._count;
                this.set_count(value);
                Unit unit = Unit.INSTANCE;
            }
            this.Notify2();
            CountUpAndDownLatch countUpAndDownLatch = this.parent;
            if (countUpAndDownLatch == null) break block3;
            countUpAndDownLatch.plus(diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTotal() {
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            int n = this.total;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setTotal(int value) {
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "Total can not be < 0: " + value;
            throw new IllegalStateException(string.toString());
        }
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            if (!(value >= this.total)) {
                boolean bl2 = false;
                String string = "Total can not decrement! (current=" + this.total + ", wanted=" + value + ')';
                throw new IllegalStateException(string.toString());
            }
            this.total = value;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void await(long timeout) {
        long start = timeout > 0L ? TimeUtil.INSTANCE.millis() : 0L;
        Object object = this.notify;
        synchronized (object) {
            long time;
            boolean bl = false;
            do {
                if (this._count == 0) {
                    return;
                }
                this.notify.wait(timeout);
            } while (timeout <= 0L || (time = TimeUtil.INSTANCE.millis()) - start < timeout);
            throw new InterruptedException("Timeout reached!");
        }
    }

    public static /* synthetic */ void await$default(CountUpAndDownLatch countUpAndDownLatch, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        countUpAndDownLatch.await(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="Notify2")
    private final void Notify2() {
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            for (Function0<Unit> callback : this.callbacks) {
                callback.invoke();
            }
            this.notify.notifyAll();
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final CountUpAndDownLatch inc() {
        this.plus(1);
        return this;
    }

    @NotNull
    public final CountUpAndDownLatch dec() {
        this.minus(1);
        return this;
    }

    public final void countUp() {
        this.plus(1);
    }

    public final void countDown() {
        this.minus(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CountUpAndDownLatch plus(int value) {
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            this.setCount(this.getCount() + value);
            Unit unit = Unit.INSTANCE;
        }
        return this;
    }

    @NotNull
    public final CountUpAndDownLatch minus(int value) {
        return this.plus(-value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForChange(long timeout) {
        long start = timeout > 0L ? TimeUtil.INSTANCE.millis() : 0L;
        Object object = this.notify;
        synchronized (object) {
            long time;
            boolean bl = false;
            int lastCount = this.getCount();
            int lastTotal = this.getTotal();
            do {
                block7: {
                    block6: {
                        int count = this.getCount();
                        int total = this.getTotal();
                        if (count != lastCount) break block6;
                        if (total == lastTotal) break block7;
                    }
                    return;
                }
                this.notify.wait(timeout);
            } while (timeout <= 0L || (time = TimeUtil.INSTANCE.millis()) - start < timeout);
            throw new InterruptedException("Timeout reached!");
        }
    }

    public static /* synthetic */ void waitForChange$default(CountUpAndDownLatch countUpAndDownLatch, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        countUpAndDownLatch.waitForChange(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitWithChange(long timeout) {
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            if (this.getTotal() == 0) {
                this.waitForChange(timeout);
            }
            this.await(timeout);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void awaitWithChange$default(CountUpAndDownLatch countUpAndDownLatch, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        countUpAndDownLatch.awaitWithChange(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void awaitOrChange(long timeout) {
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            if (this.getTotal() == 0) {
                return;
            }
            this.waitForChange(timeout);
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void awaitOrChange$default(CountUpAndDownLatch countUpAndDownLatch, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        countUpAndDownLatch.awaitOrChange(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void plusAssign(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.callbacks).add(callback);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitIfGreater(int value, long timeout) {
        Object object = this.notify;
        synchronized (object) {
            boolean bl = false;
            while (this.getCount() > value) {
                this.waitForChange(timeout);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* synthetic */ void waitIfGreater$default(CountUpAndDownLatch countUpAndDownLatch, int n, long l, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        countUpAndDownLatch.waitIfGreater(n, l);
    }

    @NotNull
    public String toString() {
        String string = "%d / %d";
        Object[] objectArray = new Object[]{this.getCount(), this.getTotal()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @JvmOverloads
    public CountUpAndDownLatch(int count) {
        this(count, null, 2, null);
    }

    @JvmOverloads
    public final void await() {
        CountUpAndDownLatch.await$default(this, 0L, 1, null);
    }
}

