/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.locale;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\nH\u0086\u0002R\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00020\n*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lde/bixilon/kutil/locale/LanguageUtil;", "", "()V", "LOCALES", "", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "[Ljava/util/Locale;", "LOCALES_MAP", "", "", "fullName", "getFullName", "(Ljava/util/Locale;)Ljava/lang/String;", "get", "name", "kutil"})
public final class LanguageUtil {
    @NotNull
    public static final LanguageUtil INSTANCE = new LanguageUtil();
    @NotNull
    private static final Locale[] LOCALES;
    @NotNull
    private static final Map<String, Locale> LOCALES_MAP;

    private LanguageUtil() {
    }

    @Nullable
    public final Locale get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String language = name;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"-", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"-"};
            language = (String)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        }
        String string = language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        language = string;
        return LOCALES_MAP.get(language);
    }

    @NotNull
    public final String getFullName(@NotNull Locale $this$fullName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$fullName, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder().append($this$fullName.getLanguage()).append('_');
        CharSequence charSequence2 = $this$fullName.getCountry();
        if (charSequence2.length() == 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            String string = $this$fullName.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"language");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            charSequence = string2;
            stringBuilder = stringBuilder2;
        } else {
            charSequence = charSequence2;
        }
        return stringBuilder.append((String)charSequence).toString();
    }

    static {
        Locale[] localeArray = new Locale[]{Locale.GERMAN, Locale.ENGLISH, Locale.FRENCH, Locale.ITALIAN, Locale.JAPANESE, Locale.KOREAN, Locale.CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
        LOCALES = localeArray;
        LOCALES_MAP = new LinkedHashMap();
        for (Locale locale : LOCALES) {
            String string;
            String string2 = locale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"locale.language");
            if (StringsKt.isBlank((CharSequence)string2)) continue;
            Map<String, Locale> map = LOCALES_MAP;
            String string3 = locale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"locale.language");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"locale");
            Locale locale2 = locale;
            map.put(string, locale2);
        }
    }
}

