/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.shutdown;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.file.watcher.FileWatcherService;
import de.bixilon.kutil.shutdown.AbstractShutdownReason;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\u0011\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0086\u0002J\u001c\u0010\u0012\u001a\u00020\u000e2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/bixilon/kutil/shutdown/ShutdownManager;", "", "()V", "hooks", "", "Ljava/lang/Runnable;", "initialized", "", "<set-?>", "shuttingDown", "getShuttingDown", "()Z", "viaHook", "addHook", "", "hook", "init", "plusAssign", "shutdown", "message", "", "reason", "Lde/bixilon/kutil/shutdown/AbstractShutdownReason;", "kutil"})
public final class ShutdownManager {
    @NotNull
    public static final ShutdownManager INSTANCE = new ShutdownManager();
    @NotNull
    private static final Set<Runnable> hooks;
    private static boolean initialized;
    private static volatile boolean shuttingDown;
    private static boolean viaHook;

    private ShutdownManager() {
    }

    public final boolean getShuttingDown() {
        return shuttingDown;
    }

    public final void shutdown(@Nullable String message, @NotNull AbstractShutdownReason reason) {
        String message2;
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (shuttingDown) {
            return;
        }
        shuttingDown = true;
        String string = message;
        if (string == null) {
            string = reason.getMessage();
        }
        if ((message2 = string) != null) {
            System.out.println((Object)("Shutting down: " + message2));
        } else {
            System.out.println((Object)"Shutting down...");
        }
        for (Runnable hook : hooks) {
            hook.run();
        }
        FileWatcherService.INSTANCE.stop();
        DefaultThreadPool.INSTANCE.shutdownNow();
        if (!viaHook) {
            System.exit(reason.getExitCode());
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    public static /* synthetic */ void shutdown$default(ShutdownManager shutdownManager, String string, AbstractShutdownReason abstractShutdownReason, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            abstractShutdownReason = AbstractShutdownReason.Companion.getDEFAULT();
        }
        shutdownManager.shutdown(string, abstractShutdownReason);
    }

    private final void init() {
        if (initialized) {
            return;
        }
        Runtime.getRuntime().addShutdownHook(new Thread(ShutdownManager::init$lambda$0, "Shutdown Hook"));
        initialized = true;
    }

    public final void addHook(@NotNull Runnable hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        if (shuttingDown) {
            throw new IllegalStateException("Already shutting down!");
        }
        ((Collection)hooks).add(hook);
    }

    public final void plusAssign(@NotNull Runnable hook) {
        Intrinsics.checkNotNullParameter((Object)hook, (String)"hook");
        this.addHook(hook);
    }

    private static final void init$lambda$0() {
        if (shuttingDown) {
            return;
        }
        viaHook = true;
        ShutdownManager.shutdown$default(INSTANCE, null, null, 3, null);
    }

    static {
        CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
        Runnable[] values$iv = new Runnable[]{};
        boolean $i$f$synchronizedSetOf = false;
        Set set = Collections.synchronizedSet(SetsKt.mutableSetOf((Object[])Arrays.copyOf(values$iv, values$iv.length)));
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(mutableSetOf(*values))");
        hooks = set;
        INSTANCE.init();
    }
}

