/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.bit.set;

import de.bixilon.kutil.bit.set.AbstractBitSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0096\u0002J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\nH\u0096\u0002J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u0011\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0007H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/bixilon/kutil/bit/set/ArrayBitSet;", "Lde/bixilon/kutil/bit/set/AbstractBitSet;", "data", "", "<init>", "([J)V", "capacity", "", "(I)V", "get", "", "index", "set", "", "value", "clear", "length", "clone", "hashCode", "equals", "other", "", "checkIndex", "Companion", "kutil"})
@SourceDebugExtension(value={"SMAP\nArrayBitSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayBitSet.kt\nde/bixilon/kutil/bit/set/ArrayBitSet\n*L\n1#1,89:1\n81#1,2:90\n81#1,2:92\n*S KotlinDebug\n*F\n+ 1 ArrayBitSet.kt\nde/bixilon/kutil/bit/set/ArrayBitSet\n*L\n24#1:90,2\n32#1:92,2\n*E\n"})
public final class ArrayBitSet
implements AbstractBitSet {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private long[] data;
    private final int capacity;
    public static final int ELEMENT_BITS = 6;
    public static final int ELEMENT_MASK = 63;

    public ArrayBitSet(@NotNull long[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.capacity = this.data.length * 64;
    }

    public ArrayBitSet(int capacity) {
        this(new long[capacity + 63 >> 6]);
    }

    @Override
    public boolean get(int index) {
        ArrayBitSet this_$iv = this;
        boolean $i$f$checkIndex = false;
        if (index < 0 || index >= this_$iv.capacity) {
            throw new IndexOutOfBoundsException("Index out of bounds " + index);
        }
        int n = index >>> 6;
        long data = this.data[n];
        long mask = 1L << (index & 0x3F);
        return (data & mask) != 0L;
    }

    @Override
    public void set(int index, boolean value) {
        ArrayBitSet this_$iv = this;
        boolean $i$f$checkIndex = false;
        if (index < 0 || index >= this_$iv.capacity) {
            throw new IndexOutOfBoundsException("Index out of bounds " + index);
        }
        int n = index >>> 6;
        long data = this.data[n];
        long mask = 1L << (index & 0x3F);
        this.data[n] = value ? data | mask : data & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        long[] lArray = this.data;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            long l = lArray[i];
            if (l == 0L) continue;
            int offset = (this.data.length - index - 1) * 64;
            int bit = 0;
            long data = l;
            while (data != 0L) {
                data >>>= 1;
                ++bit;
            }
            return bit + offset;
        }
        return 0;
    }

    @Override
    @NotNull
    public ArrayBitSet clone() {
        return new ArrayBitSet((long[])this.data.clone());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ArrayBitSet)) {
            return false;
        }
        return Arrays.equals(this.data, ((ArrayBitSet)other).data);
    }

    private final void checkIndex(int index) {
        boolean $i$f$checkIndex = false;
        if (index < 0 || index >= this.capacity) {
            throw new IndexOutOfBoundsException("Index out of bounds " + index);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/bixilon/kutil/bit/set/ArrayBitSet$Companion;", "", "<init>", "()V", "ELEMENT_BITS", "", "ELEMENT_MASK", "kutil"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

