/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.iterator.async;

import de.bixilon.kutil.collections.iterator.AsyncIterator;
import de.bixilon.kutil.collections.iterator.async.SynchronizedIterator;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ForcePooledRunnable;
import de.bixilon.kutil.exception.ExceptionUtil;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bB5\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\rJ\u001c\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001cH\u0002J$\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001cH\u0002J\u001c\u0010 \u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001a0\u001cH\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/bixilon/kutil/collections/iterator/async/ConcurrentIterator;", "T", "Lde/bixilon/kutil/collections/iterator/AsyncIterator;", "iterator", "Lde/bixilon/kutil/collections/iterator/async/SynchronizedIterator;", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "priority", "", "threads", "<init>", "(Lde/bixilon/kutil/collections/iterator/async/SynchronizedIterator;Lde/bixilon/kutil/concurrent/pool/ThreadPool;II)V", "", "(Ljava/util/Iterator;Lde/bixilon/kutil/concurrent/pool/ThreadPool;II)V", "getIterator", "()Lde/bixilon/kutil/collections/iterator/async/SynchronizedIterator;", "setIterator", "(Lde/bixilon/kutil/collections/iterator/async/SynchronizedIterator;)V", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "getPriority", "()I", "getThreads", "fresh", "", "execute", "", "executor", "Lkotlin/Function1;", "startThread", "latch", "Lde/bixilon/kutil/latch/SimpleLatch;", "iterate", "kutil"})
@SourceDebugExtension(value={"SMAP\nConcurrentIterator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConcurrentIterator.kt\nde/bixilon/kutil/collections/iterator/async/ConcurrentIterator\n+ 2 ExceptionUtil.kt\nde/bixilon/kutil/exception/ExceptionUtil\n*L\n1#1,63:1\n56#2,6:64\n*S KotlinDebug\n*F\n+ 1 ConcurrentIterator.kt\nde/bixilon/kutil/collections/iterator/async/ConcurrentIterator\n*L\n36#1:64,6\n*E\n"})
public final class ConcurrentIterator<T>
implements AsyncIterator<T> {
    @NotNull
    private SynchronizedIterator<T> iterator;
    @NotNull
    private final ThreadPool pool;
    private final int priority;
    private final int threads;
    private boolean fresh;

    public ConcurrentIterator(@NotNull SynchronizedIterator<T> iterator, @NotNull ThreadPool pool, int priority, int threads) {
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.iterator = iterator;
        this.pool = pool;
        this.priority = priority;
        this.threads = threads;
        this.fresh = true;
    }

    public /* synthetic */ ConcurrentIterator(SynchronizedIterator synchronizedIterator, ThreadPool threadPool, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = threadPool.getThreadCount();
        }
        this(synchronizedIterator, threadPool, n, n2);
    }

    @NotNull
    public final SynchronizedIterator<T> getIterator() {
        return this.iterator;
    }

    public final void setIterator(@NotNull SynchronizedIterator<T> synchronizedIterator) {
        Intrinsics.checkNotNullParameter(synchronizedIterator, (String)"<set-?>");
        this.iterator = synchronizedIterator;
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getThreads() {
        return this.threads;
    }

    public ConcurrentIterator(@NotNull Iterator<? extends T> iterator, @NotNull ThreadPool pool, int priority, int threads) {
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this(new SynchronizedIterator<T>(iterator), pool, priority, threads);
    }

    public /* synthetic */ ConcurrentIterator(Iterator iterator, ThreadPool threadPool, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = threadPool.getThreadCount();
        }
        this(iterator, threadPool, n, n2);
    }

    private final void execute(Function1<? super T, Unit> executor) {
        while (this.iterator.getOrNull() != null) {
            ExceptionUtil this_$iv = ExceptionUtil.INSTANCE;
            boolean $i$f$ignoreAll = false;
            try {
                T entry;
                boolean bl = false;
                executor.invoke(entry);
            }
            catch (Throwable error$iv) {
                error$iv.printStackTrace();
            }
        }
    }

    private final void startThread(SimpleLatch latch, Function1<? super T, Unit> executor) {
        this.pool.plusAssign(new ForcePooledRunnable(this.priority, () -> ConcurrentIterator.startThread$lambda$1(latch, this, executor)));
    }

    @Override
    public void iterate(@NotNull Function1<? super T, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        if (!this.fresh) {
            throw new IllegalStateException("Iterator is not fresh anymore!");
        }
        this.fresh = false;
        if (!this.iterator.getIterator().hasNext()) {
            return;
        }
        SimpleLatch latch = new SimpleLatch(0);
        int n = this.threads;
        for (int thread = 0; thread < n; ++thread) {
            this.startThread(latch, executor);
        }
        this.execute(executor);
        AbstractLatch.DefaultImpls.await$default(latch, 0L, 1, null);
    }

    private static final void startThread$lambda$1(SimpleLatch $latch, ConcurrentIterator this$0, Function1 $executor) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        $latch.inc();
        this$0.execute($executor);
        $latch.dec();
    }
}

