/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.iterator.async;

import de.bixilon.kutil.collections.iterator.AsyncIterator;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ForcePooledRunnable;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u001f\u001a\u00020 2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J(\u0010!\u001a\u00020 *\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\"\u001a\u00020#2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0002J6\u0010$\u001a\u00020 *\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020 0'H\u0002J6\u0010$\u001a\u00020 *\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020 0'H\u0002J\u001c\u0010(\u001a\u00020 2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020 0'H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/bixilon/kutil/collections/iterator/async/QueuedIterator;", "T", "Lde/bixilon/kutil/collections/iterator/AsyncIterator;", "iterator", "", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "priority", "", "threads", "queueSize", "<init>", "(Ljava/util/Iterator;Lde/bixilon/kutil/concurrent/pool/ThreadPool;III)V", "getIterator", "()Ljava/util/Iterator;", "setIterator", "(Ljava/util/Iterator;)V", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "getPriority", "()I", "getThreads", "getQueueSize", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "getQueue", "()Ljava/util/concurrent/ArrayBlockingQueue;", "queue$delegate", "Lkotlin/Lazy;", "fresh", "", "reuse", "", "offer", "latch", "Lde/bixilon/kutil/latch/SimpleLatch;", "work", "running", "executor", "Lkotlin/Function1;", "iterate", "kutil"})
public final class QueuedIterator<T>
implements AsyncIterator<T> {
    @NotNull
    private Iterator<? extends T> iterator;
    @NotNull
    private final ThreadPool pool;
    private final int priority;
    private final int threads;
    private final int queueSize;
    @NotNull
    private final Lazy queue$delegate;
    private boolean fresh;

    public QueuedIterator(@NotNull Iterator<? extends T> iterator, @NotNull ThreadPool pool, int priority, int threads, int queueSize) {
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.iterator = iterator;
        this.pool = pool;
        this.priority = priority;
        this.threads = threads;
        this.queueSize = queueSize;
        this.queue$delegate = LazyKt.lazy((Function0)new Function0<ArrayBlockingQueue<T>>(this){
            final /* synthetic */ QueuedIterator<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ArrayBlockingQueue<T> invoke() {
                return new ArrayBlockingQueue<E>(this.this$0.getQueueSize());
            }
        });
        this.fresh = true;
    }

    public /* synthetic */ QueuedIterator(Iterator iterator, ThreadPool threadPool, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = threadPool.getThreadCount();
        }
        if ((n4 & 0x10) != 0) {
            n3 = 1000;
        }
        this(iterator, threadPool, n, n2, n3);
    }

    @NotNull
    public final Iterator<T> getIterator() {
        return this.iterator;
    }

    public final void setIterator(@NotNull Iterator<? extends T> iterator) {
        Intrinsics.checkNotNullParameter(iterator, (String)"<set-?>");
        this.iterator = iterator;
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getThreads() {
        return this.threads;
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    private final ArrayBlockingQueue<T> getQueue() {
        Lazy lazy = this.queue$delegate;
        return (ArrayBlockingQueue)lazy.getValue();
    }

    public final void reuse(@NotNull Iterator<? extends T> iterator) {
        Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
        this.iterator = iterator;
        this.fresh = true;
    }

    private final void offer(ArrayBlockingQueue<T> $this$offer, SimpleLatch latch, Iterator<? extends T> iterator) {
        this.pool.plusAssign(new ForcePooledRunnable(100, () -> QueuedIterator.offer$lambda$0(latch, iterator, $this$offer)));
    }

    private final void work(ArrayBlockingQueue<T> $this$work, SimpleLatch latch, SimpleLatch running, Function1<? super T, Unit> executor) {
        while (true) {
            T element;
            if ((element = $this$work.poll(1L, TimeUnit.MICROSECONDS)) == null) {
                if (latch.get_count() == 0) break;
                continue;
            }
            executor.invoke(element);
        }
        running.dec();
    }

    private final void work(ArrayBlockingQueue<T> $this$work, SimpleLatch latch, int threads, Function1<? super T, Unit> executor) {
        SimpleLatch running = new SimpleLatch(threads);
        int n = running.getCount();
        for (int i = 0; i < n; ++i) {
            this.pool.plusAssign(new SimplePoolRunnable(this.priority, () -> QueuedIterator.work$lambda$1(this, $this$work, latch, running, executor)));
        }
        AbstractLatch.DefaultImpls.await$default(running, 0L, 1, null);
    }

    @Override
    public void iterate(@NotNull Function1<? super T, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        if (!this.fresh) {
            throw new IllegalStateException("Iterator is not fresh anymore!");
        }
        this.fresh = false;
        if (!this.iterator.hasNext()) {
            return;
        }
        int capacity = this.getQueue().remainingCapacity();
        SimpleLatch latch = new SimpleLatch(2);
        this.offer(this.getQueue(), latch, this.iterator);
        AbstractLatch.DefaultImpls.waitIfGreater$default(latch, 1, 0L, 2, null);
        this.work(this.getQueue(), latch, capacity < this.threads ? capacity : this.threads, executor);
    }

    private static final void offer$lambda$0(SimpleLatch $latch, Iterator $iterator, ArrayBlockingQueue $this_offer) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$iterator, (String)"$iterator");
        Intrinsics.checkNotNullParameter((Object)$this_offer, (String)"$this_offer");
        $latch.dec();
        Iterator iterator = $iterator;
        while (iterator.hasNext()) {
            Object entry = iterator.next();
            while (!$this_offer.offer(entry)) {
                Thread.sleep(1L);
            }
        }
        $latch.dec();
    }

    private static final void work$lambda$1(QueuedIterator this$0, ArrayBlockingQueue $this_work, SimpleLatch $latch, SimpleLatch $running, Function1 $executor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_work, (String)"$this_work");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$running, (String)"$running");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        this$0.work($this_work, $latch, $running, $executor);
    }
}

