/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.set.creator;

import de.bixilon.kutil.collections.set.creator.AbstractSetCreator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006H\u0016J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\tJ!\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\fJ-\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u0006H\u0016J-\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\tJ!\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\fJ-\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b\"\u0004\b\u0000\u0010\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\u000f"}, d2={"Lde/bixilon/kutil/collections/set/creator/SetCreator;", "Lde/bixilon/kutil/collections/set/creator/AbstractSetCreator;", "<init>", "()V", "uMutableSetOf", "", "E", "entries", "", "([Ljava/lang/Object;)Ljava/util/Set;", "uSetOf", "", "(Ljava/lang/Object;)Ljava/util/Set;", "sMutableSetOf", "sSetOf", "kutil"})
public final class SetCreator
implements AbstractSetCreator {
    @NotNull
    public static final SetCreator INSTANCE = new SetCreator();

    private SetCreator() {
    }

    @Override
    @NotNull
    public <E> Set<E> uMutableSetOf() {
        return new HashSet();
    }

    @Override
    @NotNull
    public <E> Set<E> uMutableSetOf(E ... entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        return SetsKt.hashSetOf((Object[])Arrays.copyOf(entries, entries.length));
    }

    @Override
    @NotNull
    public <E> Set<E> uSetOf(E entries) {
        Object[] objectArray = new Object[]{entries};
        return SetsKt.hashSetOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public <E> Set<E> uSetOf(E ... entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        return SetsKt.hashSetOf((Object[])Arrays.copyOf(entries, entries.length));
    }

    @Override
    @NotNull
    public <E> Set<E> sMutableSetOf() {
        return new LinkedHashSet();
    }

    @Override
    @NotNull
    public <E> Set<E> sMutableSetOf(E ... entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        return new LinkedHashSet();
    }

    @Override
    @NotNull
    public <E> Set<E> sSetOf(E entries) {
        Set<E> set = Collections.singleton(entries);
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        return set;
    }

    @Override
    @NotNull
    public <E> Set<E> sSetOf(E ... entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        return SetsKt.linkedSetOf((Object[])Arrays.copyOf(entries, entries.length));
    }
}

