/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.spliterator.async;

import de.bixilon.kutil.collections.spliterator.async.AsyncSpliterator;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ForcePooledRunnable;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J0\u0010 \u001a\u00020\u001c*\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0002J6\u0010$\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0'H\u0002J6\u0010$\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00028\u00000\u00182\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\b2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0'H\u0002J\u001c\u0010(\u001a\u00020\u001c2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u001c0'H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lde/bixilon/kutil/collections/spliterator/async/QueuedSpliterator;", "T", "Lde/bixilon/kutil/collections/spliterator/async/AsyncSpliterator;", "spliterator", "Ljava/util/Spliterator;", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "priority", "", "threads", "queueSize", "<init>", "(Ljava/util/Spliterator;Lde/bixilon/kutil/concurrent/pool/ThreadPool;III)V", "getSpliterator", "()Ljava/util/Spliterator;", "setSpliterator", "(Ljava/util/Spliterator;)V", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "getPriority", "()I", "getThreads", "getQueueSize", "queue", "Ljava/util/concurrent/ArrayBlockingQueue;", "fresh", "", "reuse", "", "createQueue", "estimated", "", "offer", "cacheExceeded", "latch", "Lde/bixilon/kutil/latch/SimpleLatch;", "work", "running", "executor", "Lkotlin/Function1;", "iterate", "kutil"})
public final class QueuedSpliterator<T>
implements AsyncSpliterator<T> {
    @NotNull
    private Spliterator<T> spliterator;
    @NotNull
    private final ThreadPool pool;
    private final int priority;
    private final int threads;
    private final int queueSize;
    @Nullable
    private ArrayBlockingQueue<T> queue;
    private boolean fresh;

    public QueuedSpliterator(@NotNull Spliterator<T> spliterator, @NotNull ThreadPool pool, int priority, int threads, int queueSize) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"spliterator");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.spliterator = spliterator;
        this.pool = pool;
        this.priority = priority;
        this.threads = threads;
        this.queueSize = queueSize;
        this.fresh = true;
    }

    public /* synthetic */ QueuedSpliterator(Spliterator spliterator, ThreadPool threadPool, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n4 & 4) != 0) {
            n = 0;
        }
        if ((n4 & 8) != 0) {
            n2 = threadPool.getThreadCount();
        }
        if ((n4 & 0x10) != 0) {
            n3 = 0;
        }
        this(spliterator, threadPool, n, n2, n3);
    }

    @Override
    @NotNull
    public Spliterator<T> getSpliterator() {
        return this.spliterator;
    }

    public void setSpliterator(@NotNull Spliterator<T> spliterator) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"<set-?>");
        this.spliterator = spliterator;
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final int getThreads() {
        return this.threads;
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final void reuse(@NotNull Spliterator<T> spliterator) {
        Intrinsics.checkNotNullParameter(spliterator, (String)"spliterator");
        this.setSpliterator(spliterator);
        this.fresh = true;
    }

    private final ArrayBlockingQueue<T> createQueue(long estimated) {
        ArrayBlockingQueue<Object> queue2;
        ArrayBlockingQueue<T> arrayBlockingQueue = queue2 = this.queue;
        if (arrayBlockingQueue != null) {
            return arrayBlockingQueue;
        }
        int size = this.queueSize > 0 ? this.queueSize : (estimated < 0L ? 100 : (estimated > 1000L ? 1000 : (int)estimated));
        this.queue = queue2 = new ArrayBlockingQueue(size);
        return queue2;
    }

    private final void offer(ArrayBlockingQueue<T> $this$offer, boolean cacheExceeded, SimpleLatch latch, Spliterator<T> spliterator) {
        Runnable runnable2 = () -> QueuedSpliterator.offer$lambda$1(latch, spliterator, $this$offer);
        if (!cacheExceeded) {
            this.pool.plusAssign(new SimplePoolRunnable(100, runnable2));
            return;
        }
        this.pool.plusAssign(new ForcePooledRunnable(100, runnable2));
    }

    private final void work(ArrayBlockingQueue<T> $this$work, SimpleLatch latch, SimpleLatch running, Function1<? super T, Unit> executor) {
        while (true) {
            T element;
            if ((element = $this$work.poll(1L, TimeUnit.MICROSECONDS)) == null) {
                if (latch.get_count() == 0) break;
                continue;
            }
            executor.invoke(element);
        }
        running.dec();
    }

    private final void work(ArrayBlockingQueue<T> $this$work, SimpleLatch latch, int threads, Function1<? super T, Unit> executor) {
        SimpleLatch running = new SimpleLatch(threads);
        int n = running.getCount();
        for (int i = 0; i < n; ++i) {
            this.pool.plusAssign(new SimplePoolRunnable(this.priority, () -> QueuedSpliterator.work$lambda$2(this, $this$work, latch, running, executor)));
        }
        AbstractLatch.DefaultImpls.await$default(running, 0L, 1, null);
    }

    @Override
    public void iterate(@NotNull Function1<? super T, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        if (!this.fresh) {
            throw new IllegalStateException("Spliterator is not fresh anymore!");
        }
        this.fresh = false;
        long estimated = this.getSpliterator().estimateSize();
        if (estimated == 0L) {
            return;
        }
        ArrayBlockingQueue<T> queue2 = this.createQueue(estimated);
        int capacity = queue2.remainingCapacity();
        SimpleLatch latch = new SimpleLatch(2);
        this.offer(queue2, (long)capacity < estimated, latch, this.getSpliterator());
        AbstractLatch.DefaultImpls.waitIfGreater$default(latch, 1, 0L, 2, null);
        this.work(queue2, latch, capacity < this.threads ? capacity : this.threads, executor);
    }

    private static final void offer$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void offer$lambda$1(SimpleLatch $latch, Spliterator $spliterator, ArrayBlockingQueue $this_offer) {
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$spliterator, (String)"$spliterator");
        Intrinsics.checkNotNullParameter((Object)$this_offer, (String)"$this_offer");
        $latch.dec();
        $spliterator.forEachRemaining(arg_0 -> QueuedSpliterator.offer$lambda$1$lambda$0((Function1)new Function1<T, Unit>($this_offer){
            final /* synthetic */ ArrayBlockingQueue<T> $this_offer;
            {
                this.$this_offer = $receiver;
                super(1);
            }

            public final void invoke(T it) {
                while (!this.$this_offer.offer(it)) {
                    Thread.sleep(1L);
                }
            }
        }, arg_0));
        $latch.dec();
    }

    private static final void work$lambda$2(QueuedSpliterator this$0, ArrayBlockingQueue $this_work, SimpleLatch $latch, SimpleLatch $running, Function1 $executor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_work, (String)"$this_work");
        Intrinsics.checkNotNullParameter((Object)$latch, (String)"$latch");
        Intrinsics.checkNotNullParameter((Object)$running, (String)"$running");
        Intrinsics.checkNotNullParameter((Object)$executor, (String)"$executor");
        this$0.work($this_work, $latch, $running, $executor);
    }
}

