/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool.threads;

import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.pool.threads.ThreadPoolThread;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u000e\u0010\u001d\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/bixilon/kutil/concurrent/pool/threads/ThreadManager;", "", "name", "", "count", "", "priority", "running", "Ljava/util/concurrent/atomic/AtomicInteger;", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "queue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lde/bixilon/kutil/concurrent/pool/runnable/ThreadPoolRunnable;", "<init>", "(Ljava/lang/String;IILjava/util/concurrent/atomic/AtomicInteger;Lde/bixilon/kutil/concurrent/pool/ThreadPool;Ljava/util/concurrent/PriorityBlockingQueue;)V", "getName", "()Ljava/lang/String;", "getCount", "()I", "getPriority", "getRunning", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "getQueue", "()Ljava/util/concurrent/PriorityBlockingQueue;", "threads", "getThreads", "id", "start", "", "Companion", "kutil"})
public final class ThreadManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    private final int count;
    private final int priority;
    @NotNull
    private final AtomicInteger running;
    @NotNull
    private final ThreadPool pool;
    @NotNull
    private final PriorityBlockingQueue<ThreadPoolRunnable> queue;
    @NotNull
    private final AtomicInteger threads;
    @NotNull
    private AtomicInteger id;
    @Deprecated
    public static final int WAIT_TIME = 300;

    public ThreadManager(@NotNull String name, int count, int priority, @NotNull AtomicInteger running, @NotNull ThreadPool pool, @NotNull PriorityBlockingQueue<ThreadPoolRunnable> queue2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)running, (String)"running");
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        Intrinsics.checkNotNullParameter(queue2, (String)"queue");
        this.name = name;
        this.count = count;
        this.priority = priority;
        this.running = running;
        this.pool = pool;
        this.queue = queue2;
        this.threads = new AtomicInteger();
        this.id = new AtomicInteger(0);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final AtomicInteger getRunning() {
        return this.running;
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    @NotNull
    public final PriorityBlockingQueue<ThreadPoolRunnable> getQueue() {
        return this.queue;
    }

    @NotNull
    public final AtomicInteger getThreads() {
        return this.threads;
    }

    public final void start() {
        int i;
        int n = this.count;
        for (i = 0; i < n; ++i) {
            String name = StringsKt.replace$default((String)this.name, (String)"%d", (String)String.valueOf(this.id.getAndIncrement()), (boolean)false, (int)4, null);
            new ThreadPoolThread(this, name, this.priority).start();
        }
        for (i = 0; i < 301; ++i) {
            if (this.threads.get() == this.count) {
                return;
            }
            Thread.sleep(1L);
        }
        throw new IllegalStateException("Waited 300ms for the thread pool to come up, but it did not. Maybe something is wrong?");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/bixilon/kutil/concurrent/pool/threads/ThreadManager$Companion;", "", "<init>", "()V", "WAIT_TIME", "", "kutil"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

