/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool.threads;

import de.bixilon.kutil.concurrent.pool.ThreadPoolStates;
import de.bixilon.kutil.concurrent.pool.runnable.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.pool.threads.ThreadManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lde/bixilon/kutil/concurrent/pool/threads/ThreadPoolThread;", "Ljava/lang/Thread;", "manager", "Lde/bixilon/kutil/concurrent/pool/threads/ThreadManager;", "name", "", "priority", "", "<init>", "(Lde/bixilon/kutil/concurrent/pool/threads/ThreadManager;Ljava/lang/String;I)V", "getManager", "()Lde/bixilon/kutil/concurrent/pool/threads/ThreadManager;", "run", "", "shouldStop", "", "loop", "kutil"})
public final class ThreadPoolThread
extends Thread {
    @NotNull
    private final ThreadManager manager;

    public ThreadPoolThread(@NotNull ThreadManager manager, @NotNull String name, int priority) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.manager = manager;
        this.setName(name);
        this.setPriority(priority);
    }

    @NotNull
    public final ThreadManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.manager.getThreads().incrementAndGet();
            this.loop();
        }
        finally {
            this.manager.getThreads().decrementAndGet();
        }
    }

    private final boolean shouldStop() {
        return this.manager.getPool().getState() == ThreadPoolStates.STOPPING || this.manager.getPool().getState() == ThreadPoolStates.STOPPED;
    }

    private final void loop() {
        ThreadPoolRunnable runnable2 = null;
        while (!this.shouldStop()) {
            try {
                runnable2 = this.manager.getQueue().take();
            }
            catch (InterruptedException exception) {
                continue;
            }
            this.manager.getPool().getExecutor$kutil().execute(runnable2);
            if (!this.shouldStop()) continue;
            break;
        }
    }
}

