/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.queue;

import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.time.TimeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0086\u0002J\b\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\b\b\u0002\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u000fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lde/bixilon/kutil/concurrent/queue/Queue;", "", "initialCapacity", "", "<init>", "(I)V", "queue", "", "Ljava/lang/Runnable;", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "size", "getSize", "()I", "add", "", "runnable", "plusAssign", "runFirst", "work", "maxJobs", "timeWork", "time", "", "clear", "kutil"})
@SourceDebugExtension(value={"SMAP\nQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Queue.kt\nde/bixilon/kutil/concurrent/queue/Queue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class Queue {
    @NotNull
    private final List<Runnable> queue;
    @NotNull
    private SimpleLock lock;

    public Queue(int initialCapacity) {
        this.queue = new ArrayList(initialCapacity);
        this.lock = new SimpleLock();
    }

    public /* synthetic */ Queue(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        this(n);
    }

    public final int getSize() {
        return this.queue.size();
    }

    public final void add(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.lock.lock();
        ((Collection)this.queue).add(runnable2);
        this.lock.unlock();
    }

    public final void plusAssign(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        this.add(runnable2);
    }

    private final void runFirst() {
        Runnable item = this.queue.remove(0);
        this.lock.unlock();
        try {
            item.run();
        }
        catch (Throwable exception) {
            exception.printStackTrace();
        }
    }

    public final void work(int maxJobs) {
        this.lock.lock();
        int jobsDone = 0;
        int cachedSize = this.queue.size();
        while (cachedSize-- > 0 || this.queue.size() > 0) {
            this.runFirst();
            this.lock.lock();
            if (++jobsDone != maxJobs) continue;
        }
        this.lock.unlock();
    }

    public static /* synthetic */ void work$default(Queue queue2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = Integer.MAX_VALUE;
        }
        queue2.work(n);
    }

    public final void timeWork(long time) {
        if (!(time > 0L)) {
            boolean bl = false;
            String string = "Can not have <= 0 time to do jobs!";
            throw new IllegalStateException(string.toString());
        }
        long start = TimeUtil.INSTANCE.millis();
        this.lock.lock();
        int cachedSize = this.queue.size();
        while (cachedSize-- > 0 || this.queue.size() > 0) {
            this.runFirst();
            this.lock.lock();
            if (TimeUtil.INSTANCE.millis() - start < time) continue;
        }
        this.lock.unlock();
    }

    public final void clear() {
        this.lock.lock();
        this.queue.clear();
        this.lock.unlock();
    }

    public Queue() {
        this(0, 1, null);
    }
}

