/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.schedule;

import de.bixilon.kutil.concurrent.lock.simple.SimpleLock;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.ForcePooledRunnable;
import de.bixilon.kutil.concurrent.schedule.QueuedTask;
import de.bixilon.kutil.concurrent.schedule.RepeatedTask;
import de.bixilon.kutil.concurrent.schedule.SchedulerTask;
import de.bixilon.kutil.reflection.ReflectionUtil;
import de.bixilon.kutil.shutdown.AbstractShutdownReason;
import de.bixilon.kutil.shutdown.ShutdownManager;
import de.bixilon.kutil.time.TimeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\u00020\n*\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006J\u0011\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006H\u0086\u0002J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006J\u0011\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006H\u0086\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/bixilon/kutil/concurrent/schedule/TaskScheduler;", "", "<init>", "()V", "tasks", "", "Lde/bixilon/kutil/concurrent/schedule/SchedulerTask;", "lock", "Lde/bixilon/kutil/concurrent/lock/simple/SimpleLock;", "setOptions", "", "Ljava/lang/Thread;", "startChecking", "run", "queuedTime", "", "task", "runLater", "Lde/bixilon/kutil/concurrent/schedule/QueuedTask;", "delay", "", "runnable", "Ljava/lang/Runnable;", "addTask", "plusAssign", "removeTask", "minusAssign", "kutil"})
public final class TaskScheduler {
    @NotNull
    public static final TaskScheduler INSTANCE = new TaskScheduler();
    @NotNull
    private static final Set<SchedulerTask> tasks = new LinkedHashSet();
    @NotNull
    private static final SimpleLock lock = new SimpleLock();

    private TaskScheduler() {
    }

    private final void setOptions(Thread $this$setOptions) {
        $this$setOptions.setPriority(10);
        $this$setOptions.setUncaughtExceptionHandler(TaskScheduler::setOptions$lambda$1);
    }

    private final void startChecking() {
        while (true) {
            Iterator<SchedulerTask> iterator;
            lock.lock();
            long time = TimeUtil.INSTANCE.millis();
            Iterator<SchedulerTask> iterator2 = iterator = tasks.iterator();
            while (iterator2.hasNext()) {
                long due;
                SchedulerTask task = iterator2.next();
                if (task.isExecuting() || (due = task.getNextRunDelay(time)) > 0L) continue;
                DefaultThreadPool.INSTANCE.plusAssign(new ForcePooledRunnable(task.getPriority(), () -> TaskScheduler.startChecking$lambda$2(time, task)));
                if (!(task instanceof QueuedTask)) continue;
                iterator.remove();
            }
            lock.unlock();
            Thread.sleep(1L);
        }
    }

    private final void run(long queuedTime, SchedulerTask task) {
        long time;
        if (task instanceof RepeatedTask) {
            if (!((RepeatedTask)task).getLock().tryLock(1L, TimeUnit.MILLISECONDS)) {
                return;
            }
            if (((RepeatedTask)task).isExecuting()) {
                ((RepeatedTask)task).getLock().unlock();
                return;
            }
        }
        if ((time = TimeUtil.INSTANCE.millis()) - queuedTime >= (long)task.getMaxDelay()) {
            if (task instanceof RepeatedTask) {
                ((RepeatedTask)task).getLock().unlock();
            }
            return;
        }
        try {
            task.setThread(Thread.currentThread());
            task.getRunnable().run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        task.setThread(null);
        if (task instanceof RepeatedTask) {
            RepeatedTask repeatedTask = (RepeatedTask)task;
            int n = repeatedTask.getExecutions();
            repeatedTask.setExecutions(n + 1);
            ((RepeatedTask)task).setLastExecution(queuedTime);
            ((RepeatedTask)task).getLock().unlock();
        }
    }

    @NotNull
    public final QueuedTask runLater(int delay, @NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        QueuedTask task = new QueuedTask(delay, 0, 0, runnable2, 6, null);
        this.addTask(task);
        return task;
    }

    public final void addTask(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        lock.lock();
        ((Collection)tasks).add(task);
        lock.unlock();
    }

    public final void plusAssign(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.addTask(task);
    }

    public final void removeTask(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        lock.lock();
        ((Collection)tasks).remove(task);
        lock.unlock();
    }

    public final void minusAssign(@NotNull SchedulerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.removeTask(task);
    }

    private static final void _init_$lambda$0() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread(...)");
        INSTANCE.setOptions(thread);
        INSTANCE.startChecking();
    }

    private static final void setOptions$lambda$1(Thread thread, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        error.printStackTrace();
        ShutdownManager.INSTANCE.shutdown("TaskScheduler quit unexpectedly!", AbstractShutdownReason.Companion.getCRASH());
    }

    private static final void startChecking$lambda$2(long $time, SchedulerTask $task) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        INSTANCE.run($time, $task);
    }

    static {
        new Thread(TaskScheduler::_init_$lambda$0, "TaskSchedulerThread").start();
        ReflectionUtil.INSTANCE.forceInit(DefaultThreadPool.class);
    }
}

