/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.worker.unconditional;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPool;
import de.bixilon.kutil.concurrent.pool.runnable.SimplePoolRunnable;
import de.bixilon.kutil.concurrent.worker.WorkerStates;
import de.bixilon.kutil.concurrent.worker.unconditional.UnconditionalTask;
import de.bixilon.kutil.concurrent.worker.unconditional.UnconditionalWorker;
import de.bixilon.kutil.latch.AbstractLatch;
import de.bixilon.kutil.latch.ParentLatch;
import de.bixilon.kutil.latch.SimpleLatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BG\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001aJ\u0011\u0010$\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001aH\u0086\u0002J4\u0010\"\u001a\u00020\u000b2'\u0010%\u001a#\u0012\u0015\u0012\u0013\u0018\u00010'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u000b0\tj\u0002`&\u00a2\u0006\u0002\u0010\u0017J7\u0010$\u001a\u00020\u000b2'\u0010%\u001a#\u0012\u0015\u0012\u0013\u0018\u00010'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u000b0\tj\u0002`&H\u0086\u0002\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010+\u001a\u00020,*\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010'H\u0002J&\u0010.\u001a\u00020\u000b2\u0014\u0010%\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010'\u0012\u0004\u0012\u00020\u000b0\t2\b\u0010-\u001a\u0004\u0018\u00010'J\u0012\u0010/\u001a\u00020\u000b2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010'J\u0006\u00100\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R(\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalWorker;", "", "pool", "Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "forcePool", "", "threadSafe", "autoWork", "errorHandler", "Lkotlin/Function1;", "", "", "<init>", "(Lde/bixilon/kutil/concurrent/pool/ThreadPool;ZZZLkotlin/jvm/functions/Function1;)V", "getPool", "()Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "getForcePool", "()Z", "getThreadSafe", "getAutoWork", "getErrorHandler", "()Lkotlin/jvm/functions/Function1;", "setErrorHandler", "(Lkotlin/jvm/functions/Function1;)V", "tasks", "", "Lde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalTask;", "running", "Lde/bixilon/kutil/latch/SimpleLatch;", "value", "Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "state", "getState", "()Lde/bixilon/kutil/concurrent/worker/WorkerStates;", "add", "task", "plusAssign", "executor", "Lde/bixilon/kutil/concurrent/worker/WorkerExecutor;", "Lde/bixilon/kutil/latch/AbstractLatch;", "Lkotlin/ParameterName;", "name", "progress", "createRunnable", "Lde/bixilon/kutil/concurrent/pool/runnable/SimplePoolRunnable;", "latch", "run", "work", "reset", "kutil"})
@SourceDebugExtension(value={"SMAP\nUnconditionalWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnconditionalWorker.kt\nde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalWorker\n+ 2 CollectionUtil.kt\nde/bixilon/kutil/collections/CollectionUtil\n*L\n1#1,112:1\n56#2:113\n*S KotlinDebug\n*F\n+ 1 UnconditionalWorker.kt\nde/bixilon/kutil/concurrent/worker/unconditional/UnconditionalWorker\n*L\n31#1:113\n*E\n"})
public final class UnconditionalWorker {
    @NotNull
    private final ThreadPool pool;
    private final boolean forcePool;
    private final boolean threadSafe;
    private final boolean autoWork;
    @Nullable
    private Function1<? super Throwable, Unit> errorHandler;
    @NotNull
    private final List<UnconditionalTask> tasks;
    @NotNull
    private final SimpleLatch running;
    @NotNull
    private WorkerStates state;

    public UnconditionalWorker(@NotNull ThreadPool pool, boolean forcePool, boolean threadSafe, boolean autoWork, @Nullable Function1<? super Throwable, Unit> errorHandler) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pool, (String)"pool");
        this.pool = pool;
        this.forcePool = forcePool;
        this.threadSafe = threadSafe;
        this.autoWork = autoWork;
        this.errorHandler = errorHandler;
        if (this.threadSafe) {
            CollectionUtil collectionUtil = CollectionUtil.INSTANCE;
            UnconditionalTask[] values$iv = new UnconditionalTask[]{};
            boolean $i$f$synchronizedListOf = false;
            List list2 = Collections.synchronizedList(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values$iv, values$iv.length)));
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"synchronizedList(...)");
        } else {
            list = new ArrayList();
        }
        this.tasks = list;
        this.running = new SimpleLatch(0);
        this.state = WorkerStates.PREPARING;
    }

    public /* synthetic */ UnconditionalWorker(ThreadPool threadPool, boolean bl, boolean bl2, boolean bl3, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            threadPool = DefaultThreadPool.INSTANCE;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        this(threadPool, bl, bl2, bl3, (Function1<? super Throwable, Unit>)function1);
    }

    @NotNull
    public final ThreadPool getPool() {
        return this.pool;
    }

    public final boolean getForcePool() {
        return this.forcePool;
    }

    public final boolean getThreadSafe() {
        return this.threadSafe;
    }

    public final boolean getAutoWork() {
        return this.autoWork;
    }

    @Nullable
    public final Function1<Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@Nullable Function1<? super Throwable, Unit> function1) {
        this.errorHandler = function1;
    }

    @NotNull
    public final WorkerStates getState() {
        return this.state;
    }

    public final void add(@NotNull UnconditionalTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (this.state != WorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
        }
        if (this.autoWork) {
            this.running.inc();
            SimplePoolRunnable runnable2 = this.createRunnable(task, null);
            if (this.pool.getSubmitter$kutil().submit(runnable2)) {
                return;
            }
            this.running.dec();
        }
        ((Collection)this.tasks).add(task);
    }

    public final void plusAssign(@NotNull UnconditionalTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.add(task);
    }

    public final void add(@NotNull Function1<? super AbstractLatch, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.add(new UnconditionalTask(0, executor, 1, null));
    }

    public final void plusAssign(@NotNull Function1<? super AbstractLatch, Unit> executor) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.add(executor);
    }

    private final SimplePoolRunnable createRunnable(UnconditionalTask $this$createRunnable, AbstractLatch latch) {
        return new SimplePoolRunnable($this$createRunnable.getPriority(), () -> UnconditionalWorker.createRunnable$lambda$0(this, $this$createRunnable, latch));
    }

    public final void run(@NotNull Function1<? super AbstractLatch, Unit> executor, @Nullable AbstractLatch latch) {
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        try {
            executor.invoke((Object)latch);
        }
        catch (Throwable error) {
            Function1<? super Throwable, Unit> handler = this.errorHandler;
            if (handler == null) {
                error.printStackTrace();
            }
            handler.invoke((Object)error);
        }
        AbstractLatch abstractLatch = latch;
        if (abstractLatch != null) {
            abstractLatch.dec();
        }
        this.running.dec();
    }

    public final void work(@Nullable AbstractLatch latch) {
        if (this.state != WorkerStates.PREPARING) {
            throw new IllegalStateException("Invalid state: " + (Object)((Object)this.state));
        }
        this.state = WorkerStates.WORKING;
        AbstractLatch innerLatch = latch == null ? (AbstractLatch)new SimpleLatch(1) : (AbstractLatch)new ParentLatch(1, latch);
        CollectionsKt.sortWith(this.tasks, (arg_0, arg_1) -> UnconditionalWorker.work$lambda$1(work.1.INSTANCE, arg_0, arg_1));
        innerLatch.plus(this.tasks.size());
        for (UnconditionalTask task : this.tasks) {
            this.running.inc();
            SimplePoolRunnable runnable2 = this.createRunnable(task, innerLatch);
            if (this.forcePool) {
                this.pool.getSubmitter$kutil().forceSubmit(runnable2);
                AbstractLatch.DefaultImpls.waitIfGreater$default(this.running, this.pool.getThreadCount(), 0L, 2, null);
                continue;
            }
            boolean submitted = this.pool.getSubmitter$kutil().submit(runnable2);
            if (submitted) continue;
            this.run(task.getExecutor(), innerLatch);
        }
        innerLatch.dec();
        AbstractLatch.DefaultImpls.await$default(innerLatch, 0L, 1, null);
        AbstractLatch.DefaultImpls.await$default(this.running, 0L, 1, null);
        this.state = WorkerStates.FINISHED;
    }

    public static /* synthetic */ void work$default(UnconditionalWorker unconditionalWorker, AbstractLatch abstractLatch, int n, Object object) {
        if ((n & 1) != 0) {
            abstractLatch = null;
        }
        unconditionalWorker.work(abstractLatch);
    }

    public final void reset() {
        this.tasks.clear();
        this.state = WorkerStates.PREPARING;
    }

    private static final void createRunnable$lambda$0(UnconditionalWorker this$0, UnconditionalTask $this_createRunnable, AbstractLatch $latch) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_createRunnable, (String)"$this_createRunnable");
        this$0.run($this_createRunnable.getExecutor(), $latch);
    }

    private static final int work$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public UnconditionalWorker() {
        this(null, false, false, false, null, 31, null);
    }
}

