/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.locale;

import de.bixilon.kutil.collections.map.creator.MapCreator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000bH\u0086\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082D\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lde/bixilon/kutil/locale/LanguageUtil;", "", "<init>", "()V", "LOCALES", "", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "[Ljava/util/Locale;", "LOCALES_MAP", "", "", "get", "name", "fullName", "getFullName", "(Ljava/util/Locale;)Ljava/lang/String;", "kutil"})
@SourceDebugExtension(value={"SMAP\nLanguageUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageUtil.kt\nde/bixilon/kutil/locale/LanguageUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class LanguageUtil {
    @NotNull
    public static final LanguageUtil INSTANCE = new LanguageUtil();
    @NotNull
    private static final Locale[] LOCALES;
    @NotNull
    private static final Map<String, Locale> LOCALES_MAP;

    private LanguageUtil() {
    }

    @Nullable
    public final Locale get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String language = name;
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)"-", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"-"};
            language = (String)StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0);
        }
        String string = language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        language = string;
        return LOCALES_MAP.get(language);
    }

    @NotNull
    public final String getFullName(@NotNull Locale $this$fullName) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$fullName, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder().append($this$fullName.getLanguage()).append('_');
        CharSequence charSequence2 = $this$fullName.getCountry();
        if (charSequence2.length() == 0) {
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            String string = $this$fullName.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            charSequence = string2;
            stringBuilder = stringBuilder2;
        } else {
            charSequence = charSequence2;
        }
        return stringBuilder.append((String)charSequence).toString();
    }

    static {
        Locale[] localeArray = new Locale[]{Locale.GERMAN, Locale.ENGLISH, Locale.FRENCH, Locale.ITALIAN, Locale.JAPANESE, Locale.KOREAN, Locale.CHINESE, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};
        LOCALES = localeArray;
        LOCALES_MAP = MapCreator.INSTANCE.uMutableMapOf();
        for (Locale locale : LOCALES) {
            String string;
            String string2 = locale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLanguage(...)");
            if (StringsKt.isBlank((CharSequence)string2)) continue;
            Map<String, Locale> map = LOCALES_MAP;
            String string3 = locale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLanguage(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
            map.put(string, locale);
        }
    }
}

