/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.string;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\f\u001a\u00020\r*\u00020\rJ\n\u0010\u000e\u001a\u00020\u000f*\u00020\rJ\n\u0010\u0010\u001a\u00020\u000f*\u00020\rJ \u0010\u0011\u001a\u00020\r*\u00020\r2\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0013J?\u0010\u0011\u001a\u00020\r*\u00020\r2.\u0010\u0012\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00150\u0014\"\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0015\u00a2\u0006\u0002\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\r*\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rJ\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u00020\r*\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001bJ\u001a\u0010 \u001a\u00020\r*\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\u001bR\u001e\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0086D\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/bixilon/kutil/string/StringUtil;", "", "<init>", "()V", "DEFAULT_CHARSET", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getDEFAULT_CHARSET", "()Ljava/nio/charset/Charset;", "Ljava/nio/charset/Charset;", "SNAKE_CASE_REGEX", "Lkotlin/text/Regex;", "toSnakeCase", "", "isLowercase", "", "isUppercase", "formatPlaceholder", "format", "", "", "Lkotlin/Pair;", "(Ljava/lang/String;[Lkotlin/Pair;)Ljava/lang/String;", "getBetween", "first", "second", "codePointAtOrNull", "", "index", "(Ljava/lang/String;I)Ljava/lang/Integer;", "truncate", "length", "fill", "char", "", "kutil"})
public final class StringUtil {
    @NotNull
    public static final StringUtil INSTANCE = new StringUtil();
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @NotNull
    private static final Regex SNAKE_CASE_REGEX = new Regex("(.)(\\p{Upper})");

    private StringUtil() {
    }

    public final Charset getDEFAULT_CHARSET() {
        return DEFAULT_CHARSET;
    }

    @NotNull
    public final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        Intrinsics.checkNotNullParameter((Object)$this$toSnakeCase, (String)"<this>");
        CharSequence charSequence = $this$toSnakeCase;
        Regex regex = SNAKE_CASE_REGEX;
        String string = "$1_$2";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    public final boolean isLowercase(@NotNull String $this$isLowercase) {
        Intrinsics.checkNotNullParameter((Object)$this$isLowercase, (String)"<this>");
        PrimitiveIterator.OfInt ofInt = $this$isLowercase.codePoints().iterator();
        while (ofInt.hasNext()) {
            Integer code = ofInt.next();
            Intrinsics.checkNotNull((Object)code);
            if (!Character.isUpperCase(code)) continue;
            return false;
        }
        return true;
    }

    public final boolean isUppercase(@NotNull String $this$isUppercase) {
        Intrinsics.checkNotNullParameter((Object)$this$isUppercase, (String)"<this>");
        PrimitiveIterator.OfInt ofInt = $this$isUppercase.codePoints().iterator();
        while (ofInt.hasNext()) {
            Integer code = ofInt.next();
            Intrinsics.checkNotNull((Object)code);
            if (!Character.isLowerCase(code)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String formatPlaceholder(@NotNull String $this$formatPlaceholder, @NotNull Map<String, ? extends Object> format) {
        Intrinsics.checkNotNullParameter((Object)$this$formatPlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        String output = $this$formatPlaceholder;
        for (Map.Entry<String, ? extends Object> entry : format.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            output = StringsKt.replace$default((String)output, (String)("${" + key + '}'), (String)String.valueOf(value), (boolean)false, (int)4, null);
        }
        return output;
    }

    @NotNull
    public final String formatPlaceholder(@NotNull String $this$formatPlaceholder, Pair<String, ? extends Object> ... format) {
        Intrinsics.checkNotNullParameter((Object)$this$formatPlaceholder, (String)"<this>");
        Intrinsics.checkNotNullParameter(format, (String)"format");
        String output = $this$formatPlaceholder;
        for (Pair<String, ? extends Object> pair : format) {
            String key = (String)pair.component1();
            Object value = pair.component2();
            output = StringsKt.replace$default((String)output, (String)("${" + key + '}'), (String)String.valueOf(value), (boolean)false, (int)4, null);
        }
        return output;
    }

    @NotNull
    public final String getBetween(@NotNull String $this$getBetween, @NotNull String first, @NotNull String second) {
        Intrinsics.checkNotNullParameter((Object)$this$getBetween, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        String string = $this$getBetween.substring(StringsKt.indexOf$default((CharSequence)$this$getBetween, (String)first, (int)0, (boolean)false, (int)6, null) + first.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String result = string;
        String string2 = result.substring(0, StringsKt.indexOf$default((CharSequence)result, (String)second, (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @Nullable
    public final Integer codePointAtOrNull(@NotNull String $this$codePointAtOrNull, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$codePointAtOrNull, (String)"<this>");
        if (index < 0 || index >= $this$codePointAtOrNull.length()) {
            return null;
        }
        return $this$codePointAtOrNull.codePointAt(index);
    }

    @NotNull
    public final String truncate(@NotNull String $this$truncate, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$truncate, (String)"<this>");
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be < 0: " + length);
        }
        if ($this$truncate.length() <= length) {
            return $this$truncate;
        }
        String string = $this$truncate.substring(0, length);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NotNull
    public final String fill(@NotNull String $this$fill, char c, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$fill, (String)"<this>");
        if ($this$fill.length() >= length) {
            return $this$fill;
        }
        String fill = StringsKt.repeat((CharSequence)String.valueOf(c), (int)(length - $this$fill.length()));
        return fill + $this$fill;
    }
}

