package de.brifle.sdk.api.endpoints;

import de.brifle.sdk.api.ApiMode;
import de.brifle.sdk.api.requests.CreateSignatureReferenceRequest;
import de.brifle.sdk.api.requests.ReceiverRequest;
import de.brifle.sdk.api.requests.SendContentRequest;
import de.brifle.sdk.api.responses.ApiResponse;
import de.brifle.sdk.api.responses.ErrorResponse;
import de.brifle.sdk.api.responses.content.CheckReceiverResponse;
import de.brifle.sdk.api.responses.content.GetContentResponse;
import de.brifle.sdk.api.responses.content.SendContentResponse;
import de.brifle.sdk.api.responses.signatures.CreateSignatureReferenceResponse;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class ContentEndpoint extends EndpointBase {


    public ContentEndpoint(ApiMode mode, HttpClient client) {
        super(mode, client);
    }

    /**
     * Checks if a receiver is valid
     * @param authToken the auth token generated by the authenticate method
     * @param request the request
     * @return the response
     * @throws IOException if an error occurs
     * @throws InterruptedException if an error occurs
     */
    public ApiResponse<CheckReceiverResponse> checkReceiver(final String authToken, final ReceiverRequest request) throws IOException, InterruptedException {
        String json = jsonConverter.writeValueAsString(request);
        HttpRequest httpRequest = buildPostRequest("/v1/content/receiver/check", authToken, json);
        HttpResponse<String> response = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());

        if (response.statusCode() != 200) {
            ErrorResponse errorResponse = jsonConverter.readValue(response.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        return ApiResponse.success(jsonConverter.readValue(response.body(), CheckReceiverResponse.class));
    }


    /**
     * Sends content to a receiver
     * @param authToken the auth token generated by the authenticate method
     * @param tenant the tenant id of the sender
     * @param request the request
     * @return the response
     * @throws IOException if an error occurs
     * @throws InterruptedException if an error occurs
     */
    public ApiResponse<SendContentResponse> sendContent(final String authToken, final String tenant, final SendContentRequest request) throws IOException, InterruptedException {
        String json = jsonConverter.writeValueAsString(request);
        HttpRequest httpRequest = buildPostRequest("/v1/content/send/"+tenant, authToken, json);

        HttpResponse<String> response = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());

        if (response.statusCode() != 200) {
            ErrorResponse errorResponse = jsonConverter.readValue(response.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        return ApiResponse.success(jsonConverter.readValue(response.body(), SendContentResponse.class));
    }

    public ApiResponse<GetContentResponse> getContent(final String authToken, final String id) throws IOException, InterruptedException {
        HttpRequest httpRequest = buildGetRequest("/v1/content/document/"+id, authToken);
        HttpResponse<String> response = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            ErrorResponse errorResponse = jsonConverter.readValue(response.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        return ApiResponse.success(jsonConverter.readValue(response.body(), GetContentResponse.class));

    }



}
