/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.brifle.sdk.api.ApiMode;
import de.brifle.sdk.api.endpoints.AuthEndpoint;
import de.brifle.sdk.api.endpoints.ContentEndpoint;
import de.brifle.sdk.api.endpoints.SignaturesEndpoint;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.util.Map;

public class Api {
    private ApiMode mode;
    private HttpClient client;
    private ObjectMapper jsonConverter = new ObjectMapper();
    private final SignaturesEndpoint signaturesEndpoint;
    private final ContentEndpoint contentEndpoint;
    private final AuthEndpoint authEndpoint;

    public Api(ApiMode mode) {
        this.mode = mode;
        this.client = HttpClient.newHttpClient();
        this.signaturesEndpoint = new SignaturesEndpoint(mode, this.client);
        this.contentEndpoint = new ContentEndpoint(mode, this.client);
        this.authEndpoint = new AuthEndpoint(mode, this.client);
    }

    private String toJson(Object object) {
        try {
            return this.jsonConverter.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HttpRequest buildPostRequest(String endpoint, String body) {
        return HttpRequest.newBuilder().uri(URI.create(this.mode.getUrl() + endpoint)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
    }

    private HttpRequest buildPostRequest(String endpoint, String authToken, String body) {
        return HttpRequest.newBuilder().uri(URI.create(this.mode.getUrl() + endpoint)).header("Content-Type", "application/json").headers("Authorization", "Bearer " + authToken).POST(HttpRequest.BodyPublishers.ofString(body)).build();
    }

    private HttpRequest buildPostRequest(String endpoint, Map<String, Object> body) {
        String json = this.toJson(body);
        return this.buildPostRequest(endpoint, json);
    }

    public AuthEndpoint auth() {
        return this.authEndpoint;
    }

    public SignaturesEndpoint signatures() {
        return this.signaturesEndpoint;
    }

    public ContentEndpoint content() {
        return this.contentEndpoint;
    }
}

