/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.api.endpoints;

import de.brifle.sdk.api.ApiMode;
import de.brifle.sdk.api.endpoints.EndpointBase;
import de.brifle.sdk.api.responses.ApiResponse;
import de.brifle.sdk.api.responses.ErrorResponse;
import de.brifle.sdk.api.responses.authentication.SuccessfulAuthenticationResponse;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;

public class AuthEndpoint
extends EndpointBase {
    public AuthEndpoint(ApiMode mode, HttpClient client) {
        super(mode, client);
    }

    public ApiResponse<SuccessfulAuthenticationResponse> authenticate(String apiKey, String apiSecret) throws IOException, InterruptedException {
        String endpoint = "/v1/auth/login";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("key", apiKey);
        body.put("secret", apiSecret);
        HttpRequest request = this.buildPostRequest("/v1/auth/login", body);
        HttpResponse<String> res = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        if (res.statusCode() != 200) {
            ErrorResponse errorResponse = (ErrorResponse)this.jsonConverter.readValue(res.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        SuccessfulAuthenticationResponse response = (SuccessfulAuthenticationResponse)this.jsonConverter.readValue(res.body(), SuccessfulAuthenticationResponse.class);
        return ApiResponse.success(response);
    }
}

