/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.api.endpoints;

import de.brifle.sdk.api.ApiMode;
import de.brifle.sdk.api.endpoints.EndpointBase;
import de.brifle.sdk.api.requests.ReceiverRequest;
import de.brifle.sdk.api.requests.SendContentRequest;
import de.brifle.sdk.api.responses.ApiResponse;
import de.brifle.sdk.api.responses.ErrorResponse;
import de.brifle.sdk.api.responses.content.CheckReceiverResponse;
import de.brifle.sdk.api.responses.content.GetContentResponse;
import de.brifle.sdk.api.responses.content.SendContentResponse;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class ContentEndpoint
extends EndpointBase {
    public ContentEndpoint(ApiMode mode, HttpClient client) {
        super(mode, client);
    }

    public ApiResponse<CheckReceiverResponse> checkReceiver(String authToken, ReceiverRequest request) throws IOException, InterruptedException {
        String json = this.jsonConverter.writeValueAsString((Object)request);
        HttpRequest httpRequest = this.buildPostRequest("/v1/content/receiver/check", authToken, json);
        HttpResponse<String> response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            ErrorResponse errorResponse = (ErrorResponse)this.jsonConverter.readValue(response.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        return ApiResponse.success((CheckReceiverResponse)this.jsonConverter.readValue(response.body(), CheckReceiverResponse.class));
    }

    public ApiResponse<SendContentResponse> sendContent(String authToken, String tenant, SendContentRequest request) throws IOException, InterruptedException {
        String json = this.jsonConverter.writeValueAsString((Object)request);
        HttpRequest httpRequest = this.buildPostRequest("/v1/content/send/" + tenant, authToken, json);
        HttpResponse<String> response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            ErrorResponse errorResponse = (ErrorResponse)this.jsonConverter.readValue(response.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        return ApiResponse.success((SendContentResponse)this.jsonConverter.readValue(response.body(), SendContentResponse.class));
    }

    public ApiResponse<GetContentResponse> getContent(String authToken, String id) throws IOException, InterruptedException {
        HttpRequest httpRequest = this.buildGetRequest("/v1/content/document/" + id, authToken);
        HttpResponse<String> response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            ErrorResponse errorResponse = (ErrorResponse)this.jsonConverter.readValue(response.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        return ApiResponse.success((GetContentResponse)this.jsonConverter.readValue(response.body(), GetContentResponse.class));
    }
}

