/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.helper.operators.csv;

import de.brifle.sdk.helper.IsoDateConverter;
import de.brifle.sdk.helper.operators.csv.CsvReceiverRecordType;
import java.util.Date;

public class CsvBirthInformationRecord
implements CsvReceiverRecordType {
    private String firstName;
    private String lastName;
    private Date birthDate;
    private String birthPlace;
    private String externalId;
    private String path;

    private CsvBirthInformationRecord(Builder builder) {
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.birthDate = builder.birthDate;
        this.birthPlace = builder.birthPlace;
        this.externalId = builder.externalId;
        this.path = builder.path;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public String getBirthPlace() {
        return this.birthPlace;
    }

    public String getPath() {
        return this.path;
    }

    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public String[] getHeader() {
        return new String[]{"external_id", "first_name", "last_name", "birth_date", "birth_place", "path"};
    }

    @Override
    public String[] getRecord() {
        return new String[]{this.externalId, this.firstName, this.lastName, IsoDateConverter.toIsoString(this.birthDate), this.birthPlace, this.path};
    }

    @Override
    public CsvReceiverRecordType setValues(String[] values) {
        if (values.length != 6) {
            throw new IllegalArgumentException("values length must be " + values.length);
        }
        this.externalId = values[0];
        this.firstName = values[1];
        this.lastName = values[2];
        try {
            this.birthDate = IsoDateConverter.fromIsoString(values[3]);
        }
        catch (Exception e) {
            this.birthDate = null;
        }
        this.birthPlace = values[4];
        this.path = values[5];
        return this;
    }

    public static final class Builder {
        private String firstName;
        private String lastName;
        private Date birthDate;
        private String birthPlace;
        private String externalId;
        private String path;

        public Builder withFirstName(String val) {
            this.firstName = val;
            return this;
        }

        public Builder withLastName(String val) {
            this.lastName = val;
            return this;
        }

        public Builder withBirthDate(Date val) {
            this.birthDate = val;
            return this;
        }

        public Builder withBirthDate(String val) throws Exception {
            this.birthDate = IsoDateConverter.fromIsoStringShort(val);
            return this;
        }

        public Builder withBirthPlace(String val) {
            this.birthPlace = val;
            return this;
        }

        public Builder withPath(String val) {
            this.path = val;
            return this;
        }

        public Builder withExternalId(String val) {
            this.externalId = val;
            return this;
        }

        public CsvBirthInformationRecord build() {
            return new CsvBirthInformationRecord(this);
        }
    }
}

