/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.helper.csv;

import de.brifle.sdk.helper.Crypto;
import de.brifle.sdk.helper.csv.HMacHeaderMissingException;
import de.brifle.sdk.helper.csv.HMacValidationFailedException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public class CSVParser {
    private String[] header;
    private List<String[]> rows = new LinkedList<String[]>();
    private List<String> hmacs = new LinkedList<String>();
    private final byte[] macKey;
    private final CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setSkipHeaderRecord(false).build();
    public static final String HMAC_HEADER = "__HMAC__";
    private boolean hasHMac;

    public CSVParser(byte[] macKey) {
        this.macKey = macKey;
    }

    public CSVParser(String macKey) {
        this(Crypto.hexToBytes(macKey));
    }

    public CSVParser read(String path, boolean validateHMAC) throws IOException, HMacHeaderMissingException, HMacValidationFailedException {
        FileReader in = new FileReader(path);
        org.apache.commons.csv.CSVParser records = this.csvFormat.parse((Reader)in);
        CSVRecord h = (CSVRecord)records.iterator().next();
        this.header = new String[h.size()];
        for (int i = 0; i < h.size(); ++i) {
            this.header[i] = h.get(i);
        }
        this.hasHMac = this.header[0].equals(HMAC_HEADER);
        if (validateHMAC && !this.hasHMac) {
            throw new HMacHeaderMissingException();
        }
        if (this.hasHMac) {
            String[] newHeader = new String[this.header.length - 1];
            System.arraycopy(this.header, 1, newHeader, 0, this.header.length - 1);
            this.header = newHeader;
        }
        this.loadRows((Iterable<CSVRecord>)records, validateHMAC);
        return this;
    }

    public CSVParser readString(String csvString, boolean validateHMAC) throws IOException, HMacHeaderMissingException, HMacValidationFailedException {
        StringReader in = new StringReader(csvString);
        org.apache.commons.csv.CSVParser records = this.csvFormat.parse((Reader)in);
        CSVRecord h = (CSVRecord)records.iterator().next();
        this.header = new String[h.size()];
        for (int i = 0; i < h.size(); ++i) {
            this.header[i] = h.get(i);
        }
        this.hasHMac = this.header[0].equals(HMAC_HEADER);
        if (validateHMAC && !this.hasHMac) {
            throw new HMacHeaderMissingException();
        }
        if (this.hasHMac) {
            String[] newHeader = new String[this.header.length - 1];
            System.arraycopy(this.header, 1, newHeader, 0, this.header.length - 1);
            this.header = newHeader;
        }
        this.loadRows((Iterable<CSVRecord>)records, false);
        return this;
    }

    private void loadRows(Iterable<CSVRecord> records, boolean validateHMAC) throws HMacValidationFailedException {
        while (records.iterator().hasNext()) {
            CSVRecord record = records.iterator().next();
            String[] row = new String[record.size()];
            for (int i = 0; i < record.size(); ++i) {
                row[i] = record.get(i);
            }
            if (this.hasHMac) {
                this.hmacs.add(row[0]);
                String[] newRow = new String[row.length - 1];
                System.arraycopy(row, 1, newRow, 0, row.length - 1);
                this.rows.add(newRow);
                if (!validateHMAC) continue;
                try {
                    if (this.validateHMAC(newRow, row[0])) continue;
                    throw new HMacValidationFailedException();
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    throw new HMacValidationFailedException();
                }
            }
            this.rows.add(row);
        }
    }

    private boolean validateHMAC(String[] row, String expectedHmac) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeyException {
        String hmac = Crypto.hmac(String.join((CharSequence)"", row), Crypto.bytesToHex(this.macKey));
        return hmac.equals(expectedHmac);
    }

    public String[] getHeader() {
        return this.header;
    }

    public String[][] getRows() {
        return (String[][])this.rows.toArray((T[])new String[0][0]);
    }
}

