/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.helper.operators;

import de.brifle.sdk.helper.Crypto;
import de.brifle.sdk.helper.csv.CSVBuilder;
import de.brifle.sdk.helper.csv.CSVParser;
import de.brifle.sdk.helper.csv.HMacHeaderMissingException;
import de.brifle.sdk.helper.csv.HMacValidationFailedException;
import de.brifle.sdk.helper.operators.csv.CsvReceiverRecordType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CsvOperator<Type extends CsvReceiverRecordType> {
    Class<Type> recordType;
    String macKey;

    public CsvOperator(Class<Type> recordType) {
        this.recordType = recordType;
        try {
            this.macKey = Crypto.bytesToHex(Crypto.randomKey());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public CsvOperator(Class<Type> recordType, String macKey) {
        this.recordType = recordType;
        this.macKey = macKey;
    }

    public String getMacKey() {
        return this.macKey;
    }

    public File writeCsvFile(String path, List<Type> records) {
        CsvReceiverRecordType header = null;
        try {
            header = (CsvReceiverRecordType)this.recordType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            header = (CsvReceiverRecordType)records.get(0);
        }
        String[] headers = header.getHeader();
        try {
            CSVBuilder csvBuilder = new CSVBuilder(this.macKey, headers);
            for (CsvReceiverRecordType record : records) {
                csvBuilder.addRow(record.getRecord());
            }
            return csvBuilder.writeToFile(path);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    public List<Type> readCsvFile(String path) throws HMacValidationFailedException, HMacHeaderMissingException, IOException {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        CSVParser parser = new CSVParser(this.macKey);
        boolean validateHMAC = this.macKey != null && !this.macKey.isEmpty();
        parser.read(path, validateHMAC);
        String[][] records = parser.getRows();
        return Stream.of(records).map(record -> {
            try {
                CsvReceiverRecordType newRecord = (CsvReceiverRecordType)this.recordType.getConstructor(new Class[0]).newInstance(new Object[0]);
                newRecord.setValues((String[])record);
                return newRecord;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
                return null;
            }
        }).filter(record -> record != null).collect(Collectors.toList());
    }

    public List<Type> readCsvString(String csvString) throws HMacValidationFailedException, HMacHeaderMissingException, IOException {
        CSVParser parser = new CSVParser(this.macKey);
        boolean validateHMAC = this.macKey != null && !this.macKey.isEmpty();
        parser.readString(csvString, validateHMAC);
        String[][] records = parser.getRows();
        return Stream.of(records).map(record -> {
            try {
                CsvReceiverRecordType newRecord = (CsvReceiverRecordType)this.recordType.getConstructor(new Class[0]).newInstance(new Object[0]);
                newRecord.setValues((String[])record);
                return newRecord;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ignored) {
                return null;
            }
        }).filter(record -> record != null).collect(Collectors.toList());
    }
}

