/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.api.endpoints;

import de.brifle.sdk.api.ApiMode;
import de.brifle.sdk.api.endpoints.EndpointBase;
import de.brifle.sdk.api.requests.CreateSignatureReferenceRequest;
import de.brifle.sdk.api.responses.ApiResponse;
import de.brifle.sdk.api.responses.ErrorResponse;
import de.brifle.sdk.api.responses.signatures.CreateSignatureReferenceResponse;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class SignaturesEndpoint
extends EndpointBase {
    public SignaturesEndpoint(ApiMode mode, HttpClient client) {
        super(mode, client);
    }

    public ApiResponse<CreateSignatureReferenceResponse> createSignatureReference(String authToken, String tenantId, CreateSignatureReferenceRequest request) throws IOException, InterruptedException {
        String json = this.jsonConverter.writeValueAsString((Object)request);
        HttpRequest httpRequest = this.buildPostRequest("/v1/signature/" + tenantId + "/reference", authToken, json);
        HttpResponse<String> response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            ErrorResponse errorResponse = (ErrorResponse)this.jsonConverter.readValue(response.body(), ErrorResponse.class);
            return ApiResponse.error(errorResponse);
        }
        return ApiResponse.success((CreateSignatureReferenceResponse)this.jsonConverter.readValue(response.body(), CreateSignatureReferenceResponse.class));
    }
}

