/*
 * Decompiled with CFR 0.152.
 */
package de.brifle.sdk.api.requests;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReceiverRequest {
    @JsonProperty(value="account_id")
    private String accountId;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="tel")
    private String tel;
    @JsonProperty(value="full_name")
    private String fullName;
    @JsonProperty(value="first_name")
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="date_of_birth")
    private String dateOfBirth;
    @JsonProperty(value="vat_id")
    private String vatId;
    @JsonProperty(value="ssn")
    private String ssn;
    @JsonProperty(value="birth_information")
    private ReceiverBirthInformation birthInformation;
    @JsonProperty(value="address_book")
    private ReceiverAddressBook addressBook;

    private ReceiverRequest() {
    }

    public static EmailBuilder byEmail() {
        return new EmailBuilder();
    }

    public static PhoneNumberBuilder byPhoneNumber() {
        return new ReceiverRequest().new PhoneNumberBuilder();
    }

    public static BirthInformationBuilder byBirthInformation() {
        return new BirthInformationBuilder();
    }

    public static AddressBookBuilder byAddressBook() {
        return new AddressBookBuilder();
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTel() {
        return this.tel;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getVatId() {
        return this.vatId;
    }

    public String getSsn() {
        return this.ssn;
    }

    public ReceiverBirthInformation getBirthInformation() {
        return this.birthInformation;
    }

    public ReceiverAddressBook getAddressBook() {
        return this.addressBook;
    }

    public static class EmailBuilder
    implements ContactDataBuilder {
        private String email;
        private String name;
        private String dateOfBirth;

        protected EmailBuilder() {
        }

        public EmailBuilder withEmail(String email) {
            this.email = email;
            return this;
        }

        @Override
        public ContactDataBuilder withDateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        @Override
        public ContactDataBuilder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDateOfBirth() {
            return this.dateOfBirth;
        }

        @Override
        public ReceiverRequest buildRequest() {
            ReceiverRequest request = new ReceiverRequest();
            request.email = this.email;
            request.fullName = this.name;
            request.dateOfBirth = this.dateOfBirth;
            return request;
        }
    }

    public class PhoneNumberBuilder
    implements ContactDataBuilder {
        private String phoneNumber;
        private String name;
        private String dateOfBirth;

        protected PhoneNumberBuilder() {
        }

        public PhoneNumberBuilder withPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public ContactDataBuilder withDateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        @Override
        public ContactDataBuilder withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDateOfBirth() {
            return this.dateOfBirth;
        }

        @Override
        public ReceiverRequest buildRequest() {
            ReceiverRequest request = new ReceiverRequest();
            request.tel = this.phoneNumber;
            request.fullName = this.name;
            request.dateOfBirth = this.dateOfBirth;
            return request;
        }
    }

    public static class BirthInformationBuilder {
        private String dateOfBirth;
        private String placeOfBirth;
        private String firstName;
        private String lastName;
        private String nameAtBirth;
        private String nationality;

        protected BirthInformationBuilder() {
        }

        public BirthInformationBuilder withDateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        public BirthInformationBuilder withPlaceOfBirth(String placeOfBirth) {
            this.placeOfBirth = placeOfBirth;
            return this;
        }

        public BirthInformationBuilder withFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public BirthInformationBuilder withLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public BirthInformationBuilder withNameAtBirth(String nameAtBirth) {
            this.nameAtBirth = nameAtBirth;
            return this;
        }

        public BirthInformationBuilder withNationality(String nationality) {
            this.nationality = nationality;
            return this;
        }

        public ReceiverBirthInformation build() {
            ReceiverBirthInformation birthInformation = new ReceiverBirthInformation();
            birthInformation.dateOfBirth = this.dateOfBirth;
            birthInformation.placeOfBirth = this.placeOfBirth;
            birthInformation.givenNames = this.firstName;
            birthInformation.lastName = this.lastName;
            birthInformation.birthName = this.nameAtBirth;
            birthInformation.nationality = this.nationality;
            return birthInformation;
        }

        public ReceiverRequest buildRequest() {
            ReceiverRequest request = new ReceiverRequest();
            request.birthInformation = this.build();
            return request;
        }
    }

    public static class AddressBookBuilder {
        private String id;
        private String owner;

        protected AddressBookBuilder() {
        }

        public AddressBookBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public AddressBookBuilder withOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public ReceiverAddressBook build() {
            ReceiverAddressBook addressBook = new ReceiverAddressBook();
            addressBook.id = this.id;
            addressBook.owner = this.owner;
            return addressBook;
        }

        public ReceiverRequest buildRequest() {
            ReceiverRequest request = new ReceiverRequest();
            request.addressBook = this.build();
            return request;
        }
    }

    public static class ReceiverBirthInformation {
        @JsonProperty(value="date_of_birth")
        private String dateOfBirth;
        @JsonProperty(value="place_of_birth")
        private String placeOfBirth;
        @JsonProperty(value="nationality")
        private String nationality;
        @JsonProperty(value="given_names")
        private String givenNames;
        @JsonProperty(value="last_name")
        private String lastName;
        @JsonProperty(value="birth_name")
        private String birthName;

        public String getDateOfBirth() {
            return this.dateOfBirth;
        }

        public String getPlaceOfBirth() {
            return this.placeOfBirth;
        }

        public String getNationality() {
            return this.nationality;
        }

        public String getGivenNames() {
            return this.givenNames;
        }

        public String getLastName() {
            return this.lastName;
        }

        public String getBirthName() {
            return this.birthName;
        }
    }

    public static class ReceiverAddressBook {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="owner")
        private String owner;

        public String getId() {
            return this.id;
        }

        public String getOwner() {
            return this.owner;
        }
    }

    public static interface ContactDataBuilder {
        public ContactDataBuilder withDateOfBirth(String var1);

        public ContactDataBuilder withName(String var1);

        public String getName();

        public String getDateOfBirth();

        public ReceiverRequest buildRequest();
    }
}

