/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.bdbexport.bl;

import de.bright_side.bdbexport.bl.DbExporter;
import de.bright_side.bdbexport.bl.DbUtil;
import de.bright_side.bdbexport.model.BulkExportRequest;
import de.bright_side.bdbexport.model.CatalogAndSchema;
import de.bright_side.bdbexport.model.InternalObjectExportRequest;
import de.bright_side.bdbexport.model.ObjectExportRequest;
import de.bright_side.bdbexport.model.ObjectNameFilter;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class DbExportUtil {
    public static <K> boolean in(K item, K ... items) {
        for (K i : items) {
            if (!item.equals(i)) continue;
            return true;
        }
        return false;
    }

    public static void write(OutputStream output, String string) throws Exception {
        output.write(string.getBytes(DbExporter.CHARSET));
    }

    public static InternalObjectExportRequest toInternalRequest(ObjectExportRequest exportRequest) throws Exception {
        InternalObjectExportRequest result = new InternalObjectExportRequest();
        Connection connection = exportRequest.getConnection();
        result.setConnection(connection);
        result.setDbType(DbUtil.determineDbType(exportRequest.getConnection()));
        if (DbExportUtil.noValue(exportRequest.getUserName())) {
            result.setUserName(DbUtil.determineUserName(connection));
        }
        result.setSortTableData(exportRequest.isSortTableData());
        result.setObjectType(exportRequest.getObjectType());
        result.setObjectName(exportRequest.getObjectName());
        if (!DbExportUtil.noValue(exportRequest.getWhereClause())) {
            result.setWhereClause(exportRequest.getWhereClause());
        }
        if (exportRequest.getTargetDbType() != null) {
            result.setTargetDbType(exportRequest.getTargetDbType());
        } else {
            result.setTargetDbType(result.getDbType());
        }
        if (exportRequest.getClobExportMaxLength() >= 0) {
            result.setClobExportMaxLength(exportRequest.getClobExportMaxLength());
        } else {
            result.setClobExportMaxLength(1024);
        }
        CatalogAndSchema catalogAndSchema = DbUtil.replaceEmptyWithDefaults(connection, new CatalogAndSchema(exportRequest.getCatalog(), exportRequest.getSchema()));
        result.setCatalogAndSchema(catalogAndSchema);
        return result;
    }

    public static boolean matches(BulkExportRequest exportRequest, DbExporter.ObjectType objectType, String objectName) throws Exception {
        ObjectNameFilter filter = null;
        switch (objectType) {
            case TABLE_DDL: {
                filter = exportRequest.getTableDdlFilter();
                break;
            }
            case TABLE_DATA: {
                filter = exportRequest.getTableDataFilter();
                break;
            }
            case VIEW_DDL: {
                filter = exportRequest.getViewDdlFilter();
                break;
            }
        }
        if (filter == null) {
            filter = new ObjectNameFilter();
        }
        filter.setInclude(DbExportUtil.toUpperCase(filter.getInclude()));
        filter.setExclude(DbExportUtil.toUpperCase(filter.getExclude()));
        Set<String> includeFilter = filter.getInclude();
        Set<String> excludeFilter = filter.getExclude();
        if (includeFilter == null && excludeFilter == null) {
            return true;
        }
        String useObjectName = objectName.toUpperCase();
        if (excludeFilter != null && excludeFilter.contains(useObjectName)) {
            return false;
        }
        if (includeFilter == null) {
            return true;
        }
        return includeFilter.contains(useObjectName);
    }

    public static String collectionToString(Collection<?> collection, String itemPrefix, String itemSuffix, String itemSeparator) {
        StringBuffer sb = new StringBuffer("");
        int size = collection.size();
        int pos = 0;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            sb.append(itemPrefix);
            sb.append(iterator.next());
            sb.append(itemSuffix);
            if (++pos >= size) continue;
            sb.append(itemSeparator);
        }
        return sb.toString();
    }

    public static String collectionToString(Collection<?> collection, String itemSeparator) {
        return DbExportUtil.collectionToString(collection, "", "", itemSeparator);
    }

    public static boolean noValue(String string) {
        return string == null || string.isEmpty();
    }

    public static Set<String> toUpperCase(Set<String> set) {
        if (set == null) {
            return null;
        }
        TreeSet<String> result = new TreeSet<String>();
        for (String i : set) {
            result.add(i.toUpperCase());
        }
        return result;
    }
}

