/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.bdbexport.bl;

import de.bright_side.bdbexport.bl.DbExportTables;
import de.bright_side.bdbexport.bl.DbExportUtil;
import de.bright_side.bdbexport.bl.DbExportViews;
import de.bright_side.bdbexport.bl.DbUtil;
import de.bright_side.bdbexport.model.BulkExportRequest;
import de.bright_side.bdbexport.model.CancelReceiver;
import de.bright_side.bdbexport.model.CatalogAndSchema;
import de.bright_side.bdbexport.model.InternalObjectExportRequest;
import de.bright_side.bdbexport.model.ObjectExportRequest;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class DbExporter {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final int DEFAULT_CLOB_EXPORT_MAX_LENGTH = 1024;

    public List<String> getObjectNames(Connection connection, ObjectType objectType, String catalog, String schema) throws Exception {
        return this.getObjectNames(connection, objectType, new CatalogAndSchema(catalog, schema));
    }

    private List<String> getObjectNames(Connection connection, ObjectType objectType, CatalogAndSchema catalogAndSchema) throws Exception {
        CatalogAndSchema useCatalogAndSchema = DbUtil.replaceEmptyWithDefaults(connection, catalogAndSchema);
        if (DbExportUtil.in(objectType, ObjectType.TABLE_DATA, ObjectType.TABLE_DDL)) {
            return new DbExportTables().getTableNames(connection, useCatalogAndSchema);
        }
        if (objectType == ObjectType.VIEW_DDL) {
            return new DbExportViews().getViewNames(connection, useCatalogAndSchema);
        }
        throw new Exception("Unknown object type: " + (Object)((Object)objectType));
    }

    public void objectExport(ObjectExportRequest exportRequest, OutputStream outputStream) throws Exception {
        this.objectExport(exportRequest, outputStream, new CancelReceiver());
    }

    public void objectExport(ObjectExportRequest exportRequest, OutputStream outputStream, CancelReceiver cancelReceiver) throws Exception {
        InternalObjectExportRequest internalExportRequest = DbExportUtil.toInternalRequest(exportRequest);
        switch (exportRequest.getObjectType()) {
            case TABLE_DDL: {
                new DbExportTables().exportTableDdl(internalExportRequest, outputStream);
                break;
            }
            case TABLE_DATA: {
                new DbExportTables().exportTableData(internalExportRequest, cancelReceiver, outputStream);
                break;
            }
            case VIEW_DDL: {
                new DbExportViews().exportViewDdl(internalExportRequest, outputStream);
                break;
            }
            default: {
                throw new Exception("Unknown object type: " + (Object)((Object)exportRequest.getObjectType()));
            }
        }
    }

    public String objectExportAsString(ObjectExportRequest exportRequest) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.objectExport(exportRequest, outputStream);
        return new String(outputStream.toByteArray(), CHARSET);
    }

    public void bulkExport(BulkExportRequest exportRequest, CancelReceiver cancelReceiver, OutputStream outputStream) throws Exception {
        CancelReceiver useCancelReceiver = cancelReceiver;
        if (useCancelReceiver == null) {
            useCancelReceiver = new CancelReceiver();
        }
        ArrayList<ObjectType> useObjectTypes = new ArrayList<ObjectType>();
        for (ObjectType i : ObjectType.values()) {
            if (exportRequest.getObjectTypes() != null && !exportRequest.getObjectTypes().contains((Object)i)) continue;
            useObjectTypes.add(i);
        }
        for (ObjectType objectType : useObjectTypes) {
            try {
                DbExportUtil.write(outputStream, "\n\n-- ####################################################\n");
                DbExportUtil.write(outputStream, "-- Exporting type " + ("" + (Object)((Object)objectType)).replace("_", " ") + ":\n");
                DbExportUtil.write(outputStream, "-- ####################################################\n\n");
                List<String> objectNames = this.getObjectNames(exportRequest.getConnection(), objectType, exportRequest.getCatalog(), exportRequest.getSchema());
                for (String objectName : objectNames) {
                    if (useCancelReceiver.wantToCancel()) {
                        return;
                    }
                    if (!DbExportUtil.matches(exportRequest, objectType, objectName)) continue;
                    ObjectExportRequest objectExportRequest = new ObjectExportRequest();
                    objectExportRequest.setConnection(exportRequest.getConnection());
                    objectExportRequest.setObjectName(objectName);
                    objectExportRequest.setObjectType(objectType);
                    objectExportRequest.setSortTableData(true);
                    try {
                        this.objectExport(objectExportRequest, outputStream, useCancelReceiver);
                    }
                    catch (Exception e) {
                        throw new Exception("Error while exporting object '" + objectName + "' of type " + (Object)((Object)objectType), e);
                    }
                }
                DbExportUtil.write(outputStream, "\n\n");
            }
            catch (Exception e) {
                throw new Exception("Error while exporting objects of type " + (Object)((Object)objectType), e);
            }
        }
    }

    public String bulkExportAsString(BulkExportRequest exportRequest, CancelReceiver cancelReceiver) throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.bulkExport(exportRequest, cancelReceiver, outputStream);
        return new String(outputStream.toByteArray(), CHARSET);
    }

    public String bulkExportAsString(BulkExportRequest exportRequest) throws Exception {
        return this.bulkExportAsString(exportRequest, new CancelReceiver());
    }

    public static enum ObjectType {
        TABLE_DDL,
        TABLE_DATA,
        VIEW_DDL;

    }

    public static enum DbType {
        MS_SQL_SERVER,
        H2,
        MY_SQL,
        MARIA_DB;

    }
}

