/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.bdbexport.bl;

import de.bright_side.bdbexport.bl.DbExportTableScripts;
import de.bright_side.bdbexport.bl.DbExportUtil;
import de.bright_side.bdbexport.bl.DbExporter;
import de.bright_side.bdbexport.bl.DbSqliteUtil;
import de.bright_side.bdbexport.bl.DbUtil;
import de.bright_side.bdbexport.model.CancelReceiver;
import de.bright_side.bdbexport.model.CatalogAndSchema;
import de.bright_side.bdbexport.model.InternalObjectExportRequest;
import de.bright_side.bdbexport.model.ReturnableValue;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class DbExportTables {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private static final SortedSet<String> TYPES_TO_READ_AS_DATE = DbUtil.getTypesToBeReadAsDate();
    private static final SortedSet<String> TYPES_TO_READ_AS_STRING = DbUtil.getTypesToBeReadAsString();
    private static final SortedSet<String> TYPES_TO_READ_AS_LONG = DbUtil.getTypesToBeReadAsLong();
    private static final SortedSet<String> TYPES_TO_READ_AS_DOUBLE = DbUtil.getTypesToBeReadAsDouble();
    private static final SortedSet<String> TYPES_TO_READ_AS_CLOB = DbUtil.getTypesToBeReadAsClob();
    private static final String MY_SQL_DEFAULT_CATALOG_NAME = "def";

    private SortedSet<String> getTableNamesSortedAlphabetically(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        DbExporter.DbType dbType = DbUtil.determineDbType(connection);
        if (DbExportUtil.in(dbType, DbExporter.DbType.H2, DbExporter.DbType.SQLITE)) {
            return DbUtil.getDbMetaDataObjectNamesSortedAlphabetically(connection, catalogAndSchema, "TABLE");
        }
        if (dbType == DbExporter.DbType.MS_SQL_SERVER) {
            return this.getMsSqlServerTableNamesSortedAlphabetically(connection, catalogAndSchema);
        }
        if (DbExportUtil.in(dbType, DbExporter.DbType.MY_SQL, DbExporter.DbType.MARIA_DB)) {
            return this.getMySqlMariaDbTableNamesSortedAlphabetically(connection, catalogAndSchema);
        }
        throw new Exception("Unknown data base type: '" + (Object)((Object)dbType) + "'");
    }

    private SortedSet<String> getMsSqlServerTableNamesSortedAlphabetically(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        String sql = "select TABLE_NAME from [" + catalogAndSchema.getCatalog() + "].INFORMATION_SCHEMA.TABLES where TABLE_CATALOG=? and TABLE_SCHEMA=? and TABLE_TYPE = 'BASE TABLE' order by TABLE_NAME";
        List<String> resultList = DbUtil.getStringListQueryResult(connection, sql, catalogAndSchema.getCatalog(), catalogAndSchema.getSchema());
        return new TreeSet<String>(resultList);
    }

    private SortedSet<String> getMySqlMariaDbTableNamesSortedAlphabetically(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        String useCatalog = catalogAndSchema.getCatalog();
        if (useCatalog == null) {
            useCatalog = MY_SQL_DEFAULT_CATALOG_NAME;
        }
        String sql = "select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_CATALOG = ? AND TABLE_SCHEMA = ? and TABLE_TYPE = 'BASE TABLE' ORDER BY TABLE_NAME";
        List<String> resultList = DbUtil.getStringListQueryResult(connection, sql, useCatalog, catalogAndSchema.getSchema());
        return new TreeSet<String>(resultList);
    }

    private List<String> sortTablesByDependencies(Connection connection, DbExporter.DbType dbType, DatabaseMetaData dbMetaData, CatalogAndSchema catalogAndSchema, Collection<String> tableNames) throws Exception {
        ArrayList<String> returnList = new ArrayList<String>();
        TreeSet<String> doneTables = new TreeSet<String>();
        TreeSet<String> toDoTables = new TreeSet<String>(tableNames);
        TreeMap<String, SortedSet<String>> dependencies = new TreeMap<String, SortedSet<String>>();
        for (String i : toDoTables) {
            SortedSet<String> dependentTables = DbExportTables.getTablesThatThisTableDependsOn(connection, dbType, dbMetaData, catalogAndSchema, i);
            dependentTables.retainAll(tableNames);
            dependencies.put(i, dependentTables);
        }
        int lastToDoTableSize = 0;
        while (toDoTables.size() > 0) {
            lastToDoTableSize = toDoTables.size();
            for (String i : toDoTables) {
                if (!doneTables.containsAll((Collection)dependencies.get(i))) continue;
                returnList.add(i);
                doneTables.add(i);
            }
            toDoTables.removeAll(doneTables);
            if (toDoTables.size() != lastToDoTableSize) continue;
            throw new Exception("Could not resolve all table dependencies to determine export order");
        }
        return returnList;
    }

    private static SortedSet<String> getTablesThatThisTableDependsOn(Connection connection, DbExporter.DbType dbType, DatabaseMetaData dbMetaData, CatalogAndSchema catalogAndSchema, String tableName) throws Exception {
        if (DbExportUtil.in(dbType, DbExporter.DbType.H2)) {
            return DbExportTables.getTablesThatThisTableDependsOnH2(connection, dbMetaData, catalogAndSchema, tableName);
        }
        if (DbExportUtil.in(dbType, DbExporter.DbType.MS_SQL_SERVER)) {
            return DbExportTables.getTablesThatThisTableDependsOnMsSqlServer(connection, catalogAndSchema, tableName);
        }
        if (DbExportUtil.in(dbType, DbExporter.DbType.MY_SQL, DbExporter.DbType.MARIA_DB)) {
            return DbExportTables.getTablesThatThisTableDependsOnMySql(connection, catalogAndSchema, tableName);
        }
        if (DbExportUtil.in(dbType, DbExporter.DbType.SQLITE)) {
            return new TreeSet<String>();
        }
        throw new Exception("Unknown database type: " + (Object)((Object)dbType));
    }

    private static SortedSet<String> getTablesThatThisTableDependsOnMySql(Connection connection, CatalogAndSchema catalogAndSchema, String tableName) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT rc.REFERENCED_TABLE_NAME FROM information_schema.table_constraints tc\n");
        sb.append(" left join information_schema.REFERENTIAL_CONSTRAINTS rc \n");
        sb.append("        on tc.CONSTRAINT_NAME  = rc.CONSTRAINT_NAME \n");
        sb.append("       and tc.CONSTRAINT_CATALOG  = rc.CONSTRAINT_CATALOG \n");
        sb.append("WHERE tc.table_schema = ?\n");
        sb.append("and tc.CONSTRAINT_CATALOG = ?\n");
        sb.append("AND tc.table_name = ?\n");
        sb.append("AND tc.constraint_type='FOREIGN KEY';\n");
        String sql = sb.toString();
        String schema = catalogAndSchema.getSchema();
        String catalog = catalogAndSchema.getCatalog();
        if (catalog == null) {
            catalog = MY_SQL_DEFAULT_CATALOG_NAME;
        }
        List<String> listResult = DbUtil.getStringListQueryResult(connection, sql, schema, catalog, tableName);
        return new TreeSet<String>(listResult);
    }

    private static SortedSet<String> getTablesThatThisTableDependsOnMsSqlServer(Connection connection, CatalogAndSchema catalogAndSchema, String tableName) throws Exception {
        String sql = DbExportTableScripts.getMsSqlServerTableDependenciesScript();
        sql = sql.replace("${CATALOG_NAME}", catalogAndSchema.getCatalog());
        String schema = "dbo";
        if (catalogAndSchema.getSchema() != null) {
            schema = catalogAndSchema.getSchema();
        }
        sql = sql.replace("${SCHEMA_NAME}", schema);
        sql = sql.replace("${TABLE_NAME}", tableName);
        List<String> listResult = DbUtil.getStringListQueryResult(connection, sql);
        return new TreeSet<String>(listResult);
    }

    private static SortedSet<String> getTablesThatThisTableDependsOnH2(Connection connection, DatabaseMetaData dbMetaData, CatalogAndSchema catalogAndSchema, String tableName) throws Exception {
        String sql = "select PKTABLE_NAME from INFORMATION_SCHEMA.CROSS_REFERENCES where FKTABLE_NAME = ?";
        List<String> listResult = DbUtil.getStringListQueryResult(connection, sql, tableName);
        return new TreeSet<String>(listResult);
    }

    private static SortedSet<String> getTablesThatThisTableDependsOnViaJdbc(DatabaseMetaData dbMetaData, CatalogAndSchema catalogAndSchema, String tableName) throws Exception, SQLException {
        TreeSet<String> returnSet = new TreeSet<String>();
        String catalog = catalogAndSchema.getCatalog();
        String schema = catalogAndSchema.getSchema();
        try (ResultSet resultSet = null;){
            resultSet = dbMetaData.getCrossReference(catalog, schema, "%", catalog, schema, tableName);
            while (resultSet.next()) {
                returnSet.add(resultSet.getString("PKTABLE_NAME"));
            }
        }
        return returnSet;
    }

    public List<String> getTableNames(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        SortedSet<String> tableNames = this.getTableNamesSortedAlphabetically(connection, catalogAndSchema);
        DatabaseMetaData dbMetaData = connection.getMetaData();
        DbExporter.DbType dbType = DbUtil.determineDbType(connection);
        return this.sortTablesByDependencies(connection, dbType, dbMetaData, catalogAndSchema, tableNames);
    }

    public void exportTableDdl(InternalObjectExportRequest exportRequest, OutputStream outputStream) throws Exception {
        String result;
        switch (exportRequest.getDbType()) {
            case H2: {
                result = this.createH2TableDdl(exportRequest);
                break;
            }
            case MS_SQL_SERVER: {
                result = this.createMsSqlServerTableDdl(exportRequest);
                break;
            }
            case MY_SQL: {
                result = this.createMySqlOrMariaDbServerTableDdl(exportRequest);
                break;
            }
            case MARIA_DB: {
                result = this.createMySqlOrMariaDbServerTableDdl(exportRequest);
                break;
            }
            case SQLITE: {
                result = this.createSqliteTableDdl(exportRequest);
                break;
            }
            default: {
                throw new Exception("Database type not supported for export table DDL: " + (Object)((Object)exportRequest.getDbType()));
            }
        }
        result = result + "\n\n";
        DbExportUtil.write(outputStream, result);
    }

    private String createMsSqlServerTableDdl(InternalObjectExportRequest exportRequest) throws Exception {
        Connection connection = exportRequest.getConnection();
        String sql = DbExportTableScripts.getMsSqlServerCreateTableDdlScript();
        sql = sql.replace("${CATALOG_NAME}", exportRequest.getCatalogAndSchema().getCatalog());
        sql = sql.replace("${TABLE_NAME}", exportRequest.getObjectName());
        String result = DbUtil.getStringQueryResult(connection, sql);
        result = result + "\n";
        return result;
    }

    private String createMySqlOrMariaDbServerTableDdl(InternalObjectExportRequest exportRequest) throws Exception {
        Connection connection = exportRequest.getConnection();
        return DbUtil.getStringQueryResultOfColumnWithName(connection, "show create table " + exportRequest.getCatalogAndSchema().getSchema() + "." + exportRequest.getObjectName(), "Create Table");
    }

    private String createSqliteTableDdl(InternalObjectExportRequest exportRequest) throws Exception {
        String sql = DbSqliteUtil.readSqliteDdlForObject(exportRequest.getConnection(), "table", exportRequest.getObjectName());
        sql = sql + DbSqliteUtil.readSqliteIndexDdlsForTable(exportRequest.getConnection(), exportRequest.getObjectName());
        return sql;
    }

    private String createH2TableDdl(InternalObjectExportRequest exportRequest) throws Exception {
        Connection connection = exportRequest.getConnection();
        CatalogAndSchema catalogAndSchema = exportRequest.getCatalogAndSchema();
        String sql = "SELECT SQL FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_CATALOG = ? and TABLE_SCHEMA = ? and TABLE_NAME = ?";
        String result = DbUtil.getStringQueryResult(connection, sql, catalogAndSchema.getCatalog(), catalogAndSchema.getSchema(), exportRequest.getObjectName());
        result = result + ";\n";
        return result;
    }

    public void exportTableData(InternalObjectExportRequest exportRequest, CancelReceiver cancelReceiver, OutputStream outputStream) throws Exception {
        this.exportTableDataAsInsertStatements(exportRequest, cancelReceiver, outputStream);
    }

    private void exportTableDataAsInsertStatements(InternalObjectExportRequest exportRequest, CancelReceiver cancelReceiver, OutputStream output) throws Exception {
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            Connection connection = exportRequest.getConnection();
            statement = connection.createStatement();
            String tableName = exportRequest.getObjectName();
            String whereClause = this.generateWhereClauseString(exportRequest.getWhereClause());
            resultSet = statement.executeQuery("SELECT * FROM " + tableName);
            DatabaseMetaData dbMetaData = connection.getMetaData();
            ResultSetMetaData metaData = resultSet.getMetaData();
            int numberOfColumns = metaData.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<String> columnNamesAndTypes = new ArrayList<String>();
            ArrayList<String> sortColumns = new ArrayList<String>();
            for (int i = 1; i <= numberOfColumns; ++i) {
                String columnName = metaData.getColumnName(i);
                String type = metaData.getColumnTypeName(i).toLowerCase();
                columnNames.add(columnName);
                columnNamesAndTypes.add("'" + metaData.getColumnName(i) + "'(type=" + type + ")");
                if (TYPES_TO_READ_AS_CLOB.contains(type)) continue;
                sortColumns.add(columnName);
            }
            ReturnableValue<String> pkName = new ReturnableValue<String>("");
            SortedSet<String> primaryKeyItems = DbUtil.getPrimaryKey(dbMetaData, exportRequest.getCatalogAndSchema(), tableName, pkName);
            DbExportUtil.write(output, "-- table '" + tableName + "'\n");
            DbExportUtil.write(output, "-- columns=" + DbExportUtil.collectionToString(columnNamesAndTypes, ", ") + "\n");
            DbExportUtil.write(output, "-- primary key: name = '" + pkName.getValue() + "' columns = {" + DbExportUtil.collectionToString(primaryKeyItems, ", ") + "}\n");
            String useTableColumnQuote = "\"";
            if (DbExportUtil.in(exportRequest.getTargetDbType(), DbExporter.DbType.MY_SQL, DbExporter.DbType.MARIA_DB)) {
                useTableColumnQuote = "";
            }
            if (exportRequest.isSortTableData()) {
                resultSet.close();
                String sql = "SELECT * FROM " + tableName + this.generateWhereClauseString(whereClause) + " " + this.generateOrderByString(sortColumns);
                DbExportUtil.write(output, "-- SQL: " + sql.replace("\r", "").replace("\n", " ") + "\n");
                try {
                    resultSet = statement.executeQuery(sql);
                }
                catch (Exception e) {
                    throw new Exception("Could not run query with sorted rows: >>" + sql + "<<", e);
                }
                metaData = resultSet.getMetaData();
            }
            long numberOfRows = 0L;
            while (resultSet.next() && !cancelReceiver.wantToCancel()) {
                Object type;
                DbExportUtil.write(output, "INSERT INTO " + tableName + "(" + DbExportUtil.collectionToString(columnNames, useTableColumnQuote, useTableColumnQuote, ", ") + ") VALUES (");
                TreeSet<Integer> clobColumnsToWrite = new TreeSet<Integer>();
                DbExporter.DbType sourceDataBaseType = exportRequest.getDbType();
                for (int i = 1; i <= numberOfColumns; ++i) {
                    if (i != 1) {
                        DbExportUtil.write(output, ", ");
                    }
                    if ((type = metaData.getColumnTypeName(i).toLowerCase()) == null) {
                        throw new Exception("Unknown type for column # " + i + ": null");
                    }
                    if (TYPES_TO_READ_AS_DATE.contains(type)) {
                        DbExportUtil.write(output, DbUtil.getDateOrNullAsSQLString(resultSet, i, DATE_FORMAT, sourceDataBaseType));
                        continue;
                    }
                    if (TYPES_TO_READ_AS_STRING.contains(type)) {
                        DbExportUtil.write(output, DbUtil.getNullOrStringAsSQLString(resultSet, i, sourceDataBaseType));
                        continue;
                    }
                    if (TYPES_TO_READ_AS_LONG.contains(type)) {
                        DbExportUtil.write(output, DbUtil.getLongOrNullAsSQLString(resultSet, i));
                        continue;
                    }
                    if (TYPES_TO_READ_AS_DOUBLE.contains(type)) {
                        DbExportUtil.write(output, DbUtil.getDoubleOrNulllAsSQLString(resultSet, i));
                        continue;
                    }
                    if (TYPES_TO_READ_AS_CLOB.contains(type)) {
                        clobColumnsToWrite.add(i);
                        DbExportUtil.write(output, DbUtil.getClobOrNulllAsSQLString(resultSet, i, sourceDataBaseType, exportRequest.getClobExportMaxLength()));
                        continue;
                    }
                    throw new Exception("Don't know how to write data of type '" + (String)type + "' into insert statement");
                }
                DbExportUtil.write(output, ");\n");
                if (clobColumnsToWrite.size() > 0) {
                    if (primaryKeyItems.size() == 0) {
                        throw new Exception("CLOB larger than values " + exportRequest.getClobExportMaxLength() + " characters cannot be exported if there is no primary key. (Because multiple update statements are needed to insert a CLOB value but the rows cannot be determined without a primary key)");
                    }
                    ArrayList<String> whereStringItems = new ArrayList<String>();
                    type = primaryKeyItems.iterator();
                    while (type.hasNext()) {
                        String i = (String)type.next();
                        whereStringItems.add(" " + i + " = " + DbUtil.getNullOrStringAsSQLString(resultSet, i, sourceDataBaseType) + " ");
                    }
                    String whereString = " where " + DbExportUtil.collectionToString(whereStringItems, " AND ");
                    for (Integer clobColumnIndex : clobColumnsToWrite) {
                        String columnName = metaData.getColumnName(clobColumnIndex);
                        String clobString = "";
                        Clob clob = resultSet.getClob(clobColumnIndex);
                        clobString = clob.getSubString(1L, (int)clob.length());
                        List<String> clobDataParts = DbUtil.toPartsSkipFirstPart(clobString, exportRequest.getClobExportMaxLength());
                        for (String clobDataPart : clobDataParts) {
                            String clobLine = "UPDATE " + tableName + " SET " + columnName + " = " + columnName + " || " + DbUtil.getDBString(clobDataPart, exportRequest.getTargetDbType()) + whereString + ";\n";
                            DbExportUtil.write(output, clobLine);
                        }
                    }
                }
                ++numberOfRows;
            }
            DbExportUtil.write(output, "-- " + numberOfRows + " row(s) exported\n\n");
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private String generateWhereClauseString(String whereClause) {
        if (whereClause == null || whereClause.isEmpty()) {
            return "";
        }
        return " WHERE " + whereClause;
    }

    private String generateOrderByString(List<String> columns) {
        if (columns.size() == 0) {
            return " ";
        }
        return "ORDER BY " + DbExportUtil.collectionToString(columns, "\"", "\"", ", ");
    }
}

