/*
 * Decompiled with CFR 0.152.
 */
package de.bright_side.bdbexport.bl;

import de.bright_side.bdbexport.bl.DbExportUtil;
import de.bright_side.bdbexport.bl.DbExporter;
import de.bright_side.bdbexport.model.CatalogAndSchema;
import de.bright_side.bdbexport.model.ReturnableValue;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class DbUtil {
    private static final String H2_DATABASE_NAME = "H2";
    private static final String MS_SQL_SERVER_DATABASE_NAME = "Microsoft SQL Server";
    private static final String MY_SQL_DATABASE_NAME = "MySQL";
    private static final String SQLITE_DATABASE_NAME = "SQLite";
    private static final int POS_OF_DATABASE_NAME_AND_PARAMS_IN_URL = 3;

    public static List<String> getStringListQueryResult(Connection conn, String sql, String param1) throws Exception {
        ArrayList<String> returnList = new ArrayList<String>();
        try (PreparedStatement pstmt = null;){
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, param1);
            ResultSet res = pstmt.executeQuery();
            while (res.next()) {
                returnList.add(res.getString(1));
            }
            res.close();
            ArrayList<String> arrayList = returnList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getStringListQueryResult(Connection conn, String sql, String param1, String param2) throws Exception {
        ArrayList<String> returnList = new ArrayList<String>();
        try (PreparedStatement pstmt = null;){
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, param1);
            pstmt.setString(2, param2);
            ResultSet res = pstmt.executeQuery();
            while (res.next()) {
                returnList.add(res.getString(1));
            }
            res.close();
            ArrayList<String> arrayList = returnList;
            return arrayList;
        }
    }

    public static List<String> getStringListQueryResult(Connection conn, String sql, String param1, String param2, String param3) throws Exception {
        ArrayList<String> returnList = new ArrayList<String>();
        try (PreparedStatement pstmt = null;){
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, param1);
            pstmt.setString(2, param2);
            pstmt.setString(3, param3);
            ResultSet res = pstmt.executeQuery();
            while (res.next()) {
                returnList.add(res.getString(1));
            }
            res.close();
            ArrayList<String> arrayList = returnList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getStringListQueryResult(Connection conn, String sql) throws Exception {
        ArrayList<String> returnList = new ArrayList<String>();
        try (PreparedStatement pstmt = null;){
            pstmt = conn.prepareStatement(sql);
            ResultSet res = pstmt.executeQuery();
            while (res.next()) {
                returnList.add(res.getString(1));
            }
            res.close();
            ArrayList<String> arrayList = returnList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getStringListQueryResultOfColumnWithName(Connection conn, String sql, String columnName) throws Exception {
        ArrayList<String> returnList = new ArrayList<String>();
        try (PreparedStatement pstmt = null;){
            pstmt = conn.prepareStatement(sql);
            ResultSet res = pstmt.executeQuery();
            while (res.next()) {
                returnList.add(res.getString(columnName));
            }
            res.close();
            ArrayList<String> arrayList = returnList;
            return arrayList;
        }
    }

    public static String getStringQueryResult(Connection conn, String sql, String param1) throws Exception {
        String returnValue = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, param1);
            res = pstmt.executeQuery();
            if (res.next()) {
                returnValue = res.getString(1);
            }
            String string = returnValue;
            return string;
        }
        catch (Exception e) {
            throw new Exception("Could not execute query >>" + sql + "<< (param1 = >>" + param1 + "<<)");
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static String getStringQueryResult(Connection conn, String sql, String param1, String param2) throws Exception {
        String returnValue = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, param1);
            pstmt.setString(2, param2);
            res = pstmt.executeQuery();
            if (res.next()) {
                returnValue = res.getString(1);
            }
            String string = returnValue;
            return string;
        }
        catch (Exception e) {
            throw new Exception("Could not execute query >>" + sql + "<< (param1 = >>" + param1 + "<<, param2 = >>" + param2 + "<<)");
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static String getStringQueryResult(Connection conn, String sql, String param1, String param2, String param3) throws Exception {
        String returnValue = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, param1);
            pstmt.setString(2, param2);
            pstmt.setString(3, param3);
            res = pstmt.executeQuery();
            if (res.next()) {
                returnValue = res.getString(1);
            }
            String string = returnValue;
            return string;
        }
        catch (Exception e) {
            throw new Exception("Could not execute query >>" + sql + "<< (param1 = >>" + param1 + "<<, param2 = >>" + param2 + "<<, param3 = >>" + param3 + "<<)");
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static String getStringQueryResult(Connection conn, String sql) throws Exception {
        String returnValue = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = conn.prepareStatement(sql);
            res = pstmt.executeQuery();
            if (res.next()) {
                returnValue = res.getString(1);
            }
            String string = returnValue;
            return string;
        }
        catch (Exception e) {
            throw new Exception("Could not execute query >>" + sql + "<<");
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static String getStringQueryResultOfColumnWithName(Connection conn, String sql, String columnName) throws Exception {
        String returnValue = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            pstmt = conn.prepareStatement(sql);
            res = pstmt.executeQuery();
            if (res.next()) {
                returnValue = res.getString(columnName);
            }
            String string = returnValue;
            return string;
        }
        catch (Exception e) {
            throw new Exception("Could not execute query >>" + sql + "<<");
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static List<String> getQueryResultAsSeparatedValues(Connection conn, String sql, String prefix, String suffix, String separator) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        String line = "";
        try {
            int i;
            pstmt = conn.prepareStatement(sql);
            res = pstmt.executeQuery();
            ResultSetMetaData metaData = res.getMetaData();
            for (i = 1; i <= metaData.getColumnCount(); ++i) {
                if (i > 1) {
                    line = line + separator;
                }
                line = line + prefix;
                line = line + metaData.getColumnName(i);
                line = line + suffix;
            }
            while (res.next()) {
                for (i = 1; i <= metaData.getColumnCount(); ++i) {
                    if (i > 1) {
                        line = line + separator;
                    }
                    String value = res.getString(i);
                    if (res.wasNull()) {
                        value = null;
                    }
                    if (value != null) {
                        line = line + prefix;
                    }
                    line = line + value;
                    if (value == null) continue;
                    line = line + suffix;
                }
                result.add(line);
                line = "";
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw new Exception("Could not execute query >>" + sql + "<<", e);
        }
        finally {
            if (res != null) {
                res.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static SortedSet<String> getTypesToBeReadAsDate() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("datetime");
        result.add("timestamp");
        result.add("date");
        result.add("datetime2");
        return result;
    }

    public static SortedSet<String> getTypesToBeReadAsString() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("nvarchar");
        result.add("varchar");
        result.add("varchar2");
        result.add("char");
        result.add("text");
        return result;
    }

    public static SortedSet<String> getTypesToBeReadAsLong() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("int");
        result.add("smallint");
        result.add("bigint");
        result.add("tinyint");
        result.add("number");
        result.add("integer");
        return result;
    }

    public static SortedSet<String> getTypesToBeReadAsDouble() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("float");
        result.add("double");
        result.add("decimal");
        return result;
    }

    public static SortedSet<String> getTypesToBeReadAsClob() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("clob");
        return result;
    }

    public static String getDateOrNullAsSQLString(ResultSet resultSet, int columnIndex, SimpleDateFormat format, DbExporter.DbType dataBaseType) throws Exception {
        Timestamp value = resultSet.getTimestamp(columnIndex);
        if (resultSet.wasNull()) {
            return "NULL";
        }
        return "'" + format.format(value) + "'";
    }

    public static String getNullOrStringAsSQLString(ResultSet resultSet, int columnIndex, DbExporter.DbType type) throws Exception {
        String value = resultSet.getString(columnIndex);
        if (resultSet.wasNull()) {
            return "NULL";
        }
        return DbUtil.getDBString(value, type);
    }

    public static String getNullOrStringAsSQLString(ResultSet resultSet, String columnName, DbExporter.DbType type) throws Exception {
        String value = resultSet.getString(columnName);
        if (resultSet.wasNull()) {
            return "NULL";
        }
        return DbUtil.getDBString(value, type);
    }

    public static String getDBString(String value, DbExporter.DbType type) throws Exception {
        if (value == null) {
            return "NULL";
        }
        if (DbExportUtil.in(type, DbExporter.DbType.MS_SQL_SERVER, DbExporter.DbType.MY_SQL, DbExporter.DbType.MARIA_DB, DbExporter.DbType.H2, DbExporter.DbType.SQLITE)) {
            return "'" + value.replace("'", "''").replace("\r\n", "'+Char(13)+Char(10)+'").replace("\n", "'+Char(10)+'").replace("\r", "'+Char(13)+'").replace("'", "'+Char(39)+'") + "'";
        }
        throw new Exception("Unknown type: " + (Object)((Object)type));
    }

    public static String getLongOrNullAsSQLString(ResultSet resultSet, int columnIndex) throws Exception {
        long value = resultSet.getLong(columnIndex);
        if (resultSet.wasNull()) {
            return "NULL";
        }
        return "" + value;
    }

    public static String getDoubleOrNulllAsSQLString(ResultSet resultSet, int columnIndex) throws Exception {
        double value = resultSet.getDouble(columnIndex);
        if (resultSet.wasNull()) {
            return "NULL";
        }
        return "" + value;
    }

    public static String getClobOrNulllAsSQLString(ResultSet resultSet, int columnIndex, DbExporter.DbType type, int maximumSize) throws Exception {
        Clob clob = resultSet.getClob(columnIndex);
        if (resultSet.wasNull()) {
            return "NULL";
        }
        String string = clob.getSubString(1L, Math.min(maximumSize, (int)clob.length()));
        return DbUtil.getDBString(string, type);
    }

    public static DbExporter.DbType determineDbType(Connection connection) throws Exception {
        String databaseName;
        DatabaseMetaData metaData = connection.getMetaData();
        switch (databaseName = metaData.getDatabaseProductName()) {
            case "H2": {
                return DbExporter.DbType.H2;
            }
            case "Microsoft SQL Server": {
                return DbExporter.DbType.MS_SQL_SERVER;
            }
            case "MySQL": {
                return DbExporter.DbType.MY_SQL;
            }
            case "SQLite": {
                return DbExporter.DbType.SQLITE;
            }
        }
        throw new Exception("Could not determine the database type from the database product name '" + databaseName + "'");
    }

    public static String determineUserName(Connection connection) throws Exception {
        return connection.getMetaData().getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<String> getPrimaryKey(DatabaseMetaData dbMetaData, CatalogAndSchema catalogAndSchema, String tableName, ReturnableValue<String> pkName) throws SQLException {
        TreeSet<String> returnSet = new TreeSet<String>();
        String catalog = catalogAndSchema.getCatalog();
        String schema = catalogAndSchema.getSchema();
        try (ResultSet resultSet = null;){
            resultSet = dbMetaData.getPrimaryKeys(catalog, schema, tableName);
            boolean first = true;
            while (resultSet.next()) {
                if (first) {
                    pkName.setValue(resultSet.getString("PK_NAME"));
                    first = false;
                }
                returnSet.add(resultSet.getString("COLUMN_NAME"));
            }
        }
        return returnSet;
    }

    public static List<String> toPartsSkipFirstPart(String string, int maximumLength) {
        ArrayList<String> returnList = new ArrayList<String>();
        String restString = string;
        boolean firstPart = true;
        while (restString.length() > 0) {
            int lengthOfPart = Math.min(restString.length(), maximumLength);
            if (!firstPart) {
                returnList.add(restString.substring(0, lengthOfPart));
            }
            firstPart = false;
            restString = restString.substring(lengthOfPart);
        }
        return returnList;
    }

    public static SortedSet<String> getDbMetaDataObjectNamesSortedAlphabetically(Connection connection, CatalogAndSchema catalogAndSchema, String objectTypeName) throws SQLException {
        TreeSet<String> result = new TreeSet<String>();
        DatabaseMetaData dmd = connection.getMetaData();
        ResultSet rs2 = dmd.getTables(catalogAndSchema.getCatalog(), catalogAndSchema.getSchema(), "%", null);
        while (rs2.next()) {
            if (!rs2.getString(4).equalsIgnoreCase(objectTypeName)) continue;
            result.add(rs2.getString(3));
        }
        return result;
    }

    public static String determineDatabaseNameFromJdbcUrl(Connection connection) throws Exception {
        DatabaseMetaData metaData = connection.getMetaData();
        if (metaData == null) {
            throw new Exception("Could not get database meta data");
        }
        String url = metaData.getURL();
        if (url == null) {
            throw new Exception("Could not get database JDBC URL");
        }
        String[] urlItems = url.split("/");
        if (urlItems.length != 4) {
            throw new Exception("Could not read database name from url '" + url + "'");
        }
        String schemaNameAndParameters = urlItems[3];
        int index = schemaNameAndParameters.indexOf("?");
        String databaseName = schemaNameAndParameters;
        if (index >= 0) {
            databaseName = schemaNameAndParameters.substring(0, index);
        }
        return databaseName;
    }

    public static CatalogAndSchema replaceEmptyWithDefaults(Connection connection, CatalogAndSchema catalogAndSchema) throws Exception {
        DbExporter.DbType dbType;
        String catalog = null;
        if (catalogAndSchema != null) {
            catalog = catalogAndSchema.getCatalog();
        }
        if (catalog == null) {
            catalog = connection.getCatalog();
        }
        String schema = null;
        if (catalogAndSchema != null) {
            schema = catalogAndSchema.getSchema();
        }
        if (schema == null) {
            schema = connection.getSchema();
        }
        if (DbExportUtil.in(dbType = DbUtil.determineDbType(connection), DbExporter.DbType.MY_SQL, DbExporter.DbType.MARIA_DB) && catalogAndSchema != null && catalogAndSchema.getCatalog() == null && catalogAndSchema.getSchema() == null) {
            String mem = schema;
            schema = catalog;
            catalog = mem;
        }
        return new CatalogAndSchema(catalog, schema);
    }
}

