/*
 * Decompiled with CFR 0.152.
 */
package de.bripkens.i18n.builder;

import de.bripkens.i18n.builder.I18nBuilderException;
import de.bripkens.i18n.builder.IndentionType;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class Config {
    String name;
    String pckg;
    String bundle;
    int indention = 4;
    IndentionType indentionType = IndentionType.SPACE;
    String lineBreak = "\n";

    Config() {
    }

    private void invariant(boolean val, String msg) {
        if (!val) {
            throw new I18nBuilderException(msg);
        }
    }

    void validate() {
        this.invariant(this.name != null, "interface name missing");
        this.invariant(this.pckg != null, "package configuration missing");
        this.invariant(this.bundle != null, "bundle missing");
        this.invariant(this.indention > 0, "indention must be larger than 0");
        this.invariant(this.indentionType != null, "indention type missing");
        this.invariant(this.lineBreak != null, "line break is missing");
        try {
            ResourceBundle.getBundle(this.bundle);
        }
        catch (MissingResourceException ex) {
            throw new I18nBuilderException("Bundle cannot be found", ex);
        }
    }
}

