/*
 * Decompiled with CFR 0.152.
 */
package de.bripkens.i18n.builder;

import de.bripkens.i18n.builder.MethodDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class MethodExtractor {
    private static final Pattern PLACEHOLDER = Pattern.compile("\\{(\\d+)[^}]*?\\}");

    MethodExtractor() {
    }

    List<MethodDefinition> extract(String bundleName) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            methods.add(this.toMethodDefinition(key, bundle.getString(key)));
        }
        Collections.sort(methods, MethodDefinition.COMPARATOR_NAME);
        return methods;
    }

    private MethodDefinition toMethodDefinition(String key, String value) {
        return new MethodDefinition(this.camelify(key), String.class, this.getParameterTypes(key, value), this.makeJavaDocSafe(value));
    }

    private String camelify(String name) {
        return name;
    }

    private List<Class<?>> getParameterTypes(String key, String value) {
        ArrayList returnTypes = new ArrayList();
        int paramCount = this.getParameterCount(value);
        for (int i = 0; i < paramCount; ++i) {
            returnTypes.add(String.class);
        }
        return returnTypes;
    }

    private int getParameterCount(String formatString) {
        Matcher matcher = PLACEHOLDER.matcher(formatString);
        HashSet<String> formatStringIndices = new HashSet<String>();
        while (matcher.find()) {
            formatStringIndices.add(matcher.group(1));
        }
        return formatStringIndices.size();
    }

    private String makeJavaDocSafe(String s) {
        return s;
    }
}

