/*
 * Decompiled with CFR 0.152.
 */
package de.bripkens.i18n.builder;

import de.bripkens.i18n.MessagesSource;
import de.bripkens.i18n.builder.Config;
import de.bripkens.i18n.builder.MethodDefinition;
import de.bripkens.i18n.builder.MethodExtractor;
import java.util.List;

public class SourceGenerator {
    private final Config config;
    private StringBuilder builder;

    SourceGenerator(Config config) {
        config.validate();
        this.config = config;
    }

    public String run() {
        MethodExtractor extractor = new MethodExtractor();
        final List<MethodDefinition> methods = extractor.extract(this.config.bundle);
        this.builder = new StringBuilder();
        this.packageStatement(this.config.pckg);
        this.importStatements(MessagesSource.class);
        this.annotation(MessagesSource.class, this.config.bundle);
        this.classDefinition(this.config.name, new IndentAwareBlock(){

            @Override
            public void call(int level) {
                SourceGenerator.this.methodDefinitions(methods, level);
            }
        });
        return this.builder.toString();
    }

    private void w(int level, String s) {
        this.indent(level);
        this.builder.append(s);
        this.nl();
    }

    private void nl() {
        this.builder.append(this.config.lineBreak);
    }

    private void indent(int level) {
        int totalAmount = level * this.config.indention;
        for (int i = 0; i < totalAmount; ++i) {
            this.builder.append(this.config.indentionType.getCharacter());
        }
    }

    private void packageStatement(String pckg) {
        this.builder.append("package ").append(pckg).append(";");
        this.nl();
        this.nl();
    }

    private void importStatements(Class<?> ... types) {
        for (Class<?> type : types) {
            this.builder.append("import ").append(type.getName()).append(";");
            this.nl();
        }
        this.nl();
    }

    private void annotation(Class<?> type, String value) {
        this.builder.append("@").append(type.getSimpleName()).append("(\"").append(value).append("\")");
        this.nl();
    }

    private void classDefinition(String name, IndentAwareBlock body) {
        this.builder.append("public class ").append(name).append(" {");
        this.nl();
        body.call(1);
        this.nl();
        this.builder.append("}");
        this.nl();
    }

    private void methodDefinitions(List<MethodDefinition> methods, int level) {
        if (methods.isEmpty()) {
            this.indent(level);
            this.builder.append("// empty resource bundle");
            return;
        }
        for (MethodDefinition method : methods) {
            this.methodDefinition(method, level);
        }
    }

    private void methodDefinition(MethodDefinition method, int level) {
        this.nl();
        this.w(level, "/**");
        this.w(level, " * Text from resource bundle:");
        this.w(level, " * <pre>");
        this.w(level, " * " + method.comment);
        this.w(level, " * </pre>");
        this.w(level, " */");
        this.indent(level);
        this.builder.append(method.returnType.getSimpleName()).append(" ").append(method.name).append("(");
        int paramIndex = 0;
        for (Class<?> type : method.paramTypes) {
            if (paramIndex > 0) {
                this.builder.append(",");
                this.nl();
                this.indent(level + 1);
            }
            this.builder.append(type.getSimpleName()).append(" p" + paramIndex);
            ++paramIndex;
        }
        this.builder.append(");");
        this.nl();
    }

    private static interface IndentAwareBlock {
        public void call(int var1);
    }
}

