/*
 * Decompiled with CFR 0.152.
 */
package de.bripkens.i18n;

import de.bripkens.i18n.I18nException;
import de.bripkens.i18n.MessagesSource;
import de.bripkens.i18n.ProxyCacheKey;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class Messages {
    private static final Map<ProxyCacheKey, Object> PROXY_CACHE = new ConcurrentHashMap<ProxyCacheKey, Object>();

    public static <T> T get(Class<T> proxyType, Locale locale) {
        assert (proxyType != null);
        assert (locale != null);
        assert (proxyType.isAnnotationPresent(MessagesSource.class));
        assert (proxyType.isInterface());
        ProxyCacheKey cacheKey = new ProxyCacheKey(proxyType, locale);
        if (PROXY_CACHE.containsKey(cacheKey)) {
            return (T)PROXY_CACHE.get(cacheKey);
        }
        T proxy = Messages.createNewProxy(proxyType, locale);
        PROXY_CACHE.put(cacheKey, proxy);
        return proxy;
    }

    private static <T> T createNewProxy(Class<T> proxyType, Locale locale) {
        String bundleName = proxyType.getAnnotation(MessagesSource.class).value();
        ResourceBundle bundle = Messages.getBundle(bundleName, locale);
        return (T)Proxy.newProxyInstance(Messages.class.getClassLoader(), new Class[]{proxyType}, (InvocationHandler)new MessageResolver(bundle));
    }

    private static ResourceBundle getBundle(String name, Locale locale) {
        try {
            return ResourceBundle.getBundle(name, locale);
        }
        catch (MissingResourceException ex) {
            throw new I18nException(ex);
        }
    }

    private static String format(String format, Object[] params) {
        if (params == null || params.length == 0) {
            return format;
        }
        return new MessageFormat(format).format(params);
    }

    private static class MessageResolver
    implements InvocationHandler {
        private final ResourceBundle bundle;

        private MessageResolver(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                String msg = this.bundle.getString(method.getName());
                return Messages.format(msg, args);
            }
            catch (MissingResourceException ex) {
                throw new I18nException(ex);
            }
        }
    }
}

