/*
 * Decompiled with CFR 0.152.
 */
package de.cakedown.swagmapper.reader;

import de.cakedown.swagmapper.mappable.DefaultMappable;
import de.cakedown.swagmapper.mappable.Mapable;
import de.cakedown.swagmapper.reader.Reader;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBeanReader
implements Reader {
    Logger logger = LoggerFactory.getLogger(JavaBeanReader.class);

    @Override
    public void read(Object subject, Consumer<Mapable> consumer) {
        this.outputMapable(subject, consumer);
    }

    public void outputMapable(Object subject, Consumer<Mapable> consumer) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(subject.getClass());
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Class<?> propertyType = propertyDescriptor.getPropertyType();
                DefaultMappable mapable = new DefaultMappable();
                mapable.setName(propertyDescriptor.getName());
                mapable.setType(propertyType);
                Method reader = propertyDescriptor.getReadMethod();
                if (reader != null) {
                    try {
                        mapable.setValue(propertyDescriptor.getReadMethod().invoke(subject, new Object[0]));
                    }
                    catch (IllegalAccessException e) {
                        this.logger.debug("Access Exception: " + mapable.getName(), (Throwable)e);
                    }
                }
                consumer.accept(mapable);
            }
        }
        catch (IntrospectionException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

