/*
 * Decompiled with CFR 0.152.
 */
package de.cakedown.swagmapper.resolve;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassHierarchyComparator
implements Comparator<Class> {
    Logger logger = LoggerFactory.getLogger(ClassHierarchyComparator.class);
    private static Map<Class, Long> hierarchyDepth = new ConcurrentHashMap<Class, Long>();
    Function<Class, Long> hierarchyDepthCalculator = c -> StreamSupport.stream(ClassUtils.hierarchy((Class)c, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE).spliterator(), false).count();

    @Override
    public int compare(Class o1, Class o2) {
        Long h2 = hierarchyDepth.computeIfAbsent(o1, this.hierarchyDepthCalculator);
        Long h1 = hierarchyDepth.computeIfAbsent(o1, this.hierarchyDepthCalculator);
        this.logger.debug("Hierarchy depth of {} is {}", (Object)o1.getName(), (Object)h1);
        this.logger.debug("Hierarchy depth of {} is {}", (Object)o2.getName(), (Object)h2);
        long value = h2 - h1;
        StreamSupport.stream(ClassUtils.hierarchy((Class)o1, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE).spliterator(), false).count();
        return value < 0L ? -1 : (value > 0L ? 1 : 0);
    }
}

