/*
 * Decompiled with CFR 0.152.
 */
package de.cakedown.swagmapper.resolve;

import de.cakedown.swagmapper.resolve.ClassHierarchyComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassHierarchyResolver {
    Logger logger = LoggerFactory.getLogger(ClassHierarchyResolver.class);
    private Collection<Class<?>> classList;

    public ClassHierarchyResolver(Collection<Class<?>> classList) {
        this.classList = classList;
    }

    public Optional<Class<?>> findMatchFor(Class<?> subject) {
        this.logger.debug("Searching match for: {}", (Object)subject.getName());
        ArrayList matching = new ArrayList();
        for (Class<?> clazz : this.classList) {
            this.logger.debug("Comparing with: {}", (Object)clazz.getName());
            if (!clazz.isAssignableFrom(subject)) continue;
            this.logger.debug("Matched: {} and: {}", (Object)subject.getName(), (Object)clazz.getName());
            matching.add(clazz);
        }
        Optional<Class<?>> key = matching.stream().sorted(new ClassHierarchyComparator()).findFirst();
        return key;
    }
}

