/*
 * Decompiled with CFR 0.152.
 */
package de.cakedown.swagmapper.writer;

import de.cakedown.swagmapper.SwagMapper;
import de.cakedown.swagmapper.mappable.Mapable;
import de.cakedown.swagmapper.writer.Writer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaBeanWriter
implements Writer {
    Logger logger = LoggerFactory.getLogger(JavaBeanWriter.class);

    @Override
    public void write(Object target, Mapable mapable, SwagMapper mapper) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass());
            Optional<PropertyDescriptor> targetProperty = this.findProperty(mapable.getName(), beanInfo);
            if (!targetProperty.isPresent()) {
                return;
            }
            Class<?> sourceType = mapable.getType();
            if (String.class.isAssignableFrom(sourceType) || ClassUtils.isPrimitiveOrWrapper(sourceType) || mapable.getValue() == null || targetProperty.get().getPropertyType().isAssignableFrom(sourceType)) {
                BeanUtils.setProperty((Object)target, (String)mapable.getName(), (Object)mapable.getValue());
            } else {
                this.logger.debug("Mapping recursively: " + mapable.getName());
                PropertyDescriptor targetPropertyDescriptor = targetProperty.get();
                Object destinationObject = null;
                Object targetValue = targetPropertyDescriptor.getReadMethod().invoke(target, new Object[0]);
                destinationObject = targetValue == null ? mapper.provideNew(targetPropertyDescriptor.getPropertyType()).get() : targetValue;
                mapper.map(mapable.getValue(), destinationObject, null);
                BeanUtils.setProperty((Object)target, (String)mapable.getName(), (Object)destinationObject);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private Optional<PropertyDescriptor> findProperty(String name, BeanInfo beanInfo) {
        return Arrays.stream(beanInfo.getPropertyDescriptors()).filter(info -> info.getName().equals(name)).findFirst();
    }
}

