/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.complex;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.etag.ETag;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Optional;

public class Meta
extends ScimObjectNode {
    public Meta() {
        super(null);
    }

    public static MetaBuilder builder() {
        return new MetaBuilder(new Meta());
    }

    public Optional<String> getResourceType() {
        return this.getStringAttribute("resourceType");
    }

    public void setResourceType(String resourceType) {
        this.setAttribute("resourceType", resourceType);
    }

    public Optional<Instant> getCreated() {
        return this.getDateTimeAttribute("created");
    }

    public void setCreated(String dateTime) {
        this.setAttribute("created", dateTime);
    }

    public void setCreated(OffsetDateTime dateTime) {
        this.setDateTimeAttribute("created", dateTime);
    }

    public void setCreated(LocalDateTime dateTime) {
        this.setDateTimeAttribute("created", dateTime);
    }

    public void setCreated(Instant dateTime) {
        this.setDateTimeAttribute("created", dateTime);
    }

    public Optional<Instant> getLastModified() {
        return this.getDateTimeAttribute("lastModified");
    }

    public void setLastModified(String dateTime) {
        this.setAttribute("lastModified", dateTime);
    }

    public void setLastModified(Instant dateTime) {
        this.setDateTimeAttribute("lastModified", dateTime);
    }

    public void setLastModified(OffsetDateTime dateTime) {
        this.setDateTimeAttribute("lastModified", dateTime);
    }

    public void setLastModified(LocalDateTime dateTime) {
        this.setDateTimeAttribute("lastModified", dateTime);
    }

    public Optional<String> getLocation() {
        return this.getStringAttribute("location");
    }

    public void setLocation(String location) {
        this.setAttribute("location", location);
    }

    public Optional<ETag> getVersion() {
        return this.getStringAttribute("version").map(ETag::newInstance);
    }

    public void setVersion(ETag version) {
        if (version == null) {
            this.remove("version");
        } else {
            this.set("version", (JsonNode)version);
        }
    }

    public static class MetaBuilder {
        private Meta meta;

        public MetaBuilder(Meta meta) {
            this.meta = meta;
        }

        public MetaBuilder created(Instant created) {
            this.meta.setCreated(created);
            return this;
        }

        public MetaBuilder created(LocalDateTime created) {
            this.meta.setCreated(created);
            return this;
        }

        public MetaBuilder created(OffsetDateTime created) {
            this.meta.setCreated(created.toInstant());
            return this;
        }

        public MetaBuilder lastModified(Instant lastModified) {
            this.meta.setLastModified(lastModified);
            return this;
        }

        public MetaBuilder lastModified(LocalDateTime lastModified) {
            this.meta.setLastModified(lastModified);
            return this;
        }

        public MetaBuilder lastModified(OffsetDateTime lastModified) {
            this.meta.setLastModified(lastModified.toInstant());
            return this;
        }

        public MetaBuilder location(String location) {
            this.meta.setLocation(location);
            return this;
        }

        public MetaBuilder resourceType(String resourceType) {
            this.meta.setResourceType(resourceType);
            return this;
        }

        public MetaBuilder version(String version) {
            this.meta.setVersion(ETag.builder().weak(true).tag(version).build());
            return this;
        }

        public MetaBuilder version(ETag version) {
            this.meta.setVersion(version);
            return this;
        }

        public Meta build() {
            return this.meta;
        }
    }
}

