/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.List;

public class ListResponse
extends ScimResponse {
    public ListResponse(String resourceJsonRepresentation) {
        super(JsonHelper.readJsonDocument(resourceJsonRepresentation));
    }

    public ListResponse(List<JsonNode> listedResources, Long totalResults, Integer itemsPerPage, Long startIndex) {
        super((JsonNode)null);
        this.setSchemasAttribute();
        this.setTotalResults(totalResults);
        this.setItemsPerPage(itemsPerPage);
        this.setStartIndex(startIndex);
        this.setListedResources(listedResources);
    }

    private void setSchemasAttribute() {
        ArrayNode schemas = new ArrayNode(JsonNodeFactory.instance);
        schemas.add("urn:ietf:params:scim:api:messages:2.0:ListResponse");
        JsonHelper.addAttribute((JsonNode)this, "schemas", (JsonNode)schemas);
    }

    public long getTotalResults() {
        return this.getLongAttribute("totalResults").orElse(0L);
    }

    public void setTotalResults(Long totalResults) {
        this.setAttribute("totalResults", totalResults);
    }

    public int getItemsPerPage() {
        return this.getIntegerAttribute("itemsPerPage").orElse(0);
    }

    public void setItemsPerPage(Integer itemsPerPage) {
        this.setAttribute("itemsPerPage", itemsPerPage);
    }

    public long getStartIndex() {
        return this.getLongAttribute("startIndex").orElse(1L);
    }

    public void setStartIndex(Long startIndex) {
        this.setAttribute("startIndex", startIndex);
    }

    public List<ScimObjectNode> getListedResources() {
        return this.getArrayAttribute("Resources", ScimObjectNode.class);
    }

    public void setListedResources(List<JsonNode> listedResources) {
        this.setAttribute("Resources", listedResources);
    }

    @Override
    public int getHttpStatus() {
        return 200;
    }
}

