/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.schemas;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.Mutability;
import de.captaingoldfish.scim.sdk.common.constants.enums.ReferenceTypes;
import de.captaingoldfish.scim.sdk.common.constants.enums.Returned;
import de.captaingoldfish.scim.sdk.common.constants.enums.Type;
import de.captaingoldfish.scim.sdk.common.constants.enums.Uniqueness;
import de.captaingoldfish.scim.sdk.common.exceptions.InvalidSchemaException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.schemas.Schema;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SchemaAttribute
extends ScimObjectNode {
    private final Schema schema;
    private final SchemaAttribute parent;
    private final String resourceUri;
    private final String namePrefix;

    protected SchemaAttribute(Schema schema, String resourceUri, SchemaAttribute parent, JsonNode jsonNode, String namePrefix) {
        super(null);
        this.schema = schema;
        this.resourceUri = resourceUri;
        this.namePrefix = namePrefix;
        Function<String, String> errorMessageBuilder = attribute -> "could not find required attribute '" + attribute + "' in meta-schema for attribute: " + this.getScimNodeName();
        String nameAttribute = "name";
        String nameErrorMessage = errorMessageBuilder.apply("name");
        this.setName(JsonHelper.getSimpleAttribute(jsonNode, "name").orElseThrow(() -> this.getException(nameErrorMessage, null)));
        String typeAttribute = "type";
        String typeErrorMessage = errorMessageBuilder.apply("type");
        Type type = Type.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "type").orElseThrow(() -> this.getException(typeErrorMessage, null)));
        this.setType(type);
        String descriptionAttribute = "description";
        String descriptionErrorMessage = errorMessageBuilder.apply("description");
        this.setDescription(JsonHelper.getSimpleAttribute(jsonNode, "description").orElseThrow(() -> this.getException(descriptionErrorMessage, null)));
        this.setMutability(Mutability.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "mutability").orElse(null)));
        this.setReturned(Returned.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "returned").orElse(null)));
        this.setUniqueness(Uniqueness.getByValue(JsonHelper.getSimpleAttribute(jsonNode, "uniqueness").orElse(Uniqueness.NONE.getValue())));
        this.setMultiValued(JsonHelper.getSimpleAttribute(jsonNode, "multiValued", Boolean.class).orElse(false));
        this.setRequired(JsonHelper.getSimpleAttribute(jsonNode, "required", Boolean.class).orElse(false));
        this.setCaseExact(JsonHelper.getSimpleAttribute(jsonNode, "caseExact", Boolean.class).orElse(false));
        this.setCanonicalValues(JsonHelper.getSimpleAttributeArray(jsonNode, "canonicalValues").orElse(Collections.emptyList()));
        this.setReferenceTypes(JsonHelper.getSimpleAttributeArray(jsonNode, "referenceTypes").map(strings -> strings.stream().map(ReferenceTypes::getByValue).collect(Collectors.toList())).orElse(Type.REFERENCE.equals((Object)type) ? Collections.singletonList(ReferenceTypes.EXTERNAL) : Collections.emptyList()));
        this.setSubAttributes(this.resolveSubAttributes(jsonNode));
        this.parent = parent;
        this.validateAttribute();
        schema.addSchemaAttribute(this);
    }

    public SchemaAttribute(Schema schema, String resourceUri, SchemaAttribute parent, JsonNode jsonNode) {
        this(schema, resourceUri, parent, jsonNode, null);
    }

    public String getFullResourceName() {
        return this.getParent() == null ? this.getResourceUri() + ":" + this.getScimNodeName() : this.getResourceUri() + ":" + this.getScimNodeName();
    }

    @Override
    public String getScimNodeName() {
        return this.getParent() == null ? this.getNamePrefix() + this.getName() : this.getParent().getScimNodeName() + "." + this.getName();
    }

    public String getNamePrefix() {
        return this.namePrefix == null ? "" : this.namePrefix + ".";
    }

    public String getName() {
        return this.getStringAttribute("name").orElse(null);
    }

    private void setName(String name) {
        this.setAttribute("name", name);
    }

    public Type getType() {
        return this.getStringAttribute("type").map(Type::getByValue).orElse(null);
    }

    private void setType(Type type) {
        this.setAttribute("type", (String)Optional.ofNullable(type).map(Type::getValue).orElse(null));
    }

    public String getDescription() {
        return this.getStringAttribute("description").orElse(null);
    }

    private void setDescription(String description) {
        this.setAttribute("description", description);
    }

    @Override
    public Mutability getMutability() {
        return this.getStringAttribute("mutability").map(Mutability::getByValue).orElse(null);
    }

    private void setMutability(Mutability mutability) {
        this.setAttribute("mutability", (String)Optional.ofNullable(mutability).map(Mutability::getValue).orElse(null));
    }

    @Override
    public Returned getReturned() {
        return this.getStringAttribute("returned").map(Returned::getByValue).orElse(null);
    }

    private void setReturned(Returned returned) {
        this.setAttribute("returned", (String)Optional.ofNullable(returned).map(Returned::getValue).orElse(null));
    }

    @Override
    public Uniqueness getUniqueness() {
        return this.getStringAttribute("uniqueness").map(Uniqueness::getByValue).orElse(null);
    }

    private void setUniqueness(Uniqueness uniqueness) {
        this.setAttribute("uniqueness", (String)Optional.ofNullable(uniqueness).map(Uniqueness::getValue).orElse(null));
    }

    @Override
    public boolean isMultiValued() {
        return this.getBooleanAttribute("multiValued").orElse(false);
    }

    private void setMultiValued(boolean multiValued) {
        this.setAttribute("multiValued", multiValued);
    }

    @Override
    public boolean isRequired() {
        return this.getBooleanAttribute("required").orElse(false);
    }

    private void setRequired(boolean required) {
        this.setAttribute("required", required);
    }

    @Override
    public boolean isCaseExact() {
        return this.getBooleanAttribute("caseExact").orElse(false);
    }

    private void setCaseExact(boolean caseExact) {
        this.setAttribute("caseExact", caseExact);
    }

    @Override
    public List<String> getCanonicalValues() {
        return this.getSimpleArrayAttribute("canonicalValues");
    }

    private void setCanonicalValues(List<String> canonicalValues) {
        this.setStringAttributeList("canonicalValues", canonicalValues);
    }

    @Override
    public List<ReferenceTypes> getReferenceTypes() {
        return this.getSimpleArrayAttribute("referenceTypes").stream().map(ReferenceTypes::getByValue).collect(Collectors.toList());
    }

    private void setReferenceTypes(List<ReferenceTypes> referenceTypes) {
        this.setStringAttributeList("referenceTypes", referenceTypes.stream().map(ReferenceTypes::getValue).collect(Collectors.toList()));
    }

    public List<SchemaAttribute> getSubAttributes() {
        return this.getArrayAttribute("subAttributes", SchemaAttribute.class);
    }

    private void setSubAttributes(List<SchemaAttribute> subAttributes) {
        this.setAttribute("subAttributes", subAttributes);
    }

    private List<SchemaAttribute> resolveSubAttributes(JsonNode jsonNode) {
        if (!Type.COMPLEX.equals((Object)this.getType())) {
            return Collections.emptyList();
        }
        ArrayList<SchemaAttribute> schemaAttributeList = new ArrayList<SchemaAttribute>();
        String subAttributeName = "subAttributes";
        String errorMessage = "missing attribute 'subAttributes' on '" + (Object)((Object)this.getType()) + "'-attribute with name: " + this.getName();
        ArrayNode subAttributesArray = JsonHelper.getArrayAttribute(jsonNode, "subAttributes").orElseThrow(() -> this.getException(errorMessage, null));
        HashSet<String> attributeNameSet = new HashSet<String>();
        boolean hasValueAttribute = false;
        boolean isResourceReference = false;
        for (JsonNode subAttribute : subAttributesArray) {
            SchemaAttribute schemaAttribute = new SchemaAttribute(this.schema, this.resourceUri, this, subAttribute, this.namePrefix);
            if (attributeNameSet.contains(schemaAttribute.getScimNodeName())) {
                String duplicateNameMessage = "the attribute with the name '" + schemaAttribute.getFullResourceName() + "' was found twice within the given schema declaration";
                throw new InvalidSchemaException(duplicateNameMessage, null, null, null);
            }
            if (!Mutability.READ_ONLY.equals((Object)this.getMutability())) {
                if ("value".equals(schemaAttribute.getName())) {
                    hasValueAttribute = true;
                }
                if ("$ref".equals(schemaAttribute.getName()) && schemaAttribute.getReferenceTypes().contains((Object)ReferenceTypes.RESOURCE)) {
                    isResourceReference = true;
                }
            }
            attributeNameSet.add(schemaAttribute.getScimNodeName());
            schemaAttributeList.add(schemaAttribute);
        }
        if (hasValueAttribute && isResourceReference) {
            this.schema.getBulkIdCandidates().add(this);
        }
        return schemaAttributeList;
    }

    private void validateAttribute() {
        Mutability mutability = this.getMutability();
        Returned returned = this.getReturned();
        if (Mutability.READ_ONLY.equals((Object)mutability) && Returned.NEVER.equals((Object)returned)) {
            String errorMessage = "the attribute with the name '" + this.getFullResourceName() + "' has an invalid declaration. mutability 'readOnly' and returned 'never' are an illegal combination. The client is not able to write to the given attribute and the server will never return it.";
            throw this.getException(errorMessage, null);
        }
        if (Mutability.WRITE_ONLY.equals((Object)mutability) && !Returned.NEVER.equals((Object)returned)) {
            String errorMessage = "the attribute with the name '" + this.getFullResourceName() + "' has an invalid declaration. mutability 'writeOnly' must have a returned value of 'never' are an illegal in combination. The client should only write to this attribute but should never have it returned. The mutability writeOnly makes only sense for sensitive application data like passwords or other secrets.";
            throw this.getException(errorMessage, null);
        }
    }

    private InvalidSchemaException getException(String errorMessage, Exception cause) {
        return new InvalidSchemaException(errorMessage, (Throwable)cause, 500, null);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public SchemaAttribute getParent() {
        return this.parent;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaAttribute)) {
            return false;
        }
        SchemaAttribute other = (SchemaAttribute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$resourceUri = this.getResourceUri();
        String other$resourceUri = other.getResourceUri();
        if (this$resourceUri == null ? other$resourceUri != null : !this$resourceUri.equals(other$resourceUri)) {
            return false;
        }
        String this$namePrefix = this.getNamePrefix();
        String other$namePrefix = other.getNamePrefix();
        return !(this$namePrefix == null ? other$namePrefix != null : !this$namePrefix.equals(other$namePrefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $resourceUri = this.getResourceUri();
        result = result * 59 + ($resourceUri == null ? 43 : $resourceUri.hashCode());
        String $namePrefix = this.getNamePrefix();
        result = result * 59 + ($namePrefix == null ? 43 : $namePrefix.hashCode());
        return result;
    }
}

