// Generated by delombok at Mon May 31 21:27:25 CEST 2021
package de.captaingoldfish.scim.sdk.common.response;

import java.util.Collections;
import java.util.List;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.constants.SchemaUris;


/**
 * author Pascal Knueppel <br>
 * created at: 25.10.2019 - 20:34 <br>
 * <br>
 * represents a simple bulk response
 */
public class BulkResponse extends ScimResponse
{

  /**
   * the http status that should be set with this response
   */
  private int httpStatus;

  public BulkResponse(List<BulkResponseOperation> bulkResponseOperation, int httpStatus)
  {
    this();
    setBulkResponseOperations(bulkResponseOperation);
    this.httpStatus = httpStatus;
  }

  public BulkResponse()
  {
    super(null);
    setSchemas(Collections.singletonList(SchemaUris.BULK_RESPONSE_URI));
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int getHttpStatus()
  {
    return httpStatus;
  }

  /**
   * Defines operations within a bulk job. Each operation corresponds to a single HTTP request against a
   * resource endpoint. REQUIRED.
   */
  public List<BulkResponseOperation> getBulkResponseOperations()
  {
    List<BulkResponseOperation> operations = getArrayAttribute(AttributeNames.RFC7643.OPERATIONS,
                                                               BulkResponseOperation.class);
    if (operations.isEmpty())
    {
      setAttribute(AttributeNames.RFC7643.OPERATIONS, operations);
    }
    return operations;
  }

  /**
   * Defines operations within a bulk job. Each operation corresponds to a single HTTP request against a
   * resource endpoint. REQUIRED.
   */
  public void setBulkResponseOperations(List<BulkResponseOperation> bulkRequestOperations)
  {
    setAttribute(AttributeNames.RFC7643.OPERATIONS, bulkRequestOperations);
  }


  @java.lang.SuppressWarnings("all")
  public static class BulkResponseBuilder
  {

    @java.lang.SuppressWarnings("all")
    private List<BulkResponseOperation> bulkResponseOperation;

    @java.lang.SuppressWarnings("all")
    private int httpStatus;

    @java.lang.SuppressWarnings("all")
    BulkResponseBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public BulkResponse.BulkResponseBuilder bulkResponseOperation(final List<BulkResponseOperation> bulkResponseOperation)
    {
      this.bulkResponseOperation = bulkResponseOperation;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public BulkResponse.BulkResponseBuilder httpStatus(final int httpStatus)
    {
      this.httpStatus = httpStatus;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public BulkResponse build()
    {
      return new BulkResponse(this.bulkResponseOperation, this.httpStatus);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "BulkResponse.BulkResponseBuilder(bulkResponseOperation=" + this.bulkResponseOperation + ", httpStatus="
             + this.httpStatus + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static BulkResponse.BulkResponseBuilder builder()
  {
    return new BulkResponse.BulkResponseBuilder();
  }
}
