/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources;

import de.captaingoldfish.scim.sdk.common.resources.ResourceNode;
import de.captaingoldfish.scim.sdk.common.resources.complex.BulkConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ChangePasswordConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ETagConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.FilterConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.SortConfig;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.AuthenticationScheme;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceProvider
extends ResourceNode {
    private static final Logger log = LoggerFactory.getLogger(ServiceProvider.class);
    private ForkJoinPool threadPool = ForkJoinPool.commonPool();

    public ServiceProvider(String documentationUri, PatchConfig patchConfig, ChangePasswordConfig changePasswordConfig, SortConfig sortConfig, ETagConfig eTagConfig, FilterConfig filterConfig, BulkConfig bulkConfig, List<AuthenticationScheme> authenticationSchemes, ForkJoinPool forkJoinPool) {
        this.setSchemas(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig"));
        this.setDocumentationUri(documentationUri);
        this.setPatchConfig(patchConfig);
        this.setChangePasswordConfig(changePasswordConfig);
        this.setSortConfig(sortConfig);
        this.setETagConfig(eTagConfig);
        this.setFilterConfig(filterConfig);
        this.setBulkConfig(bulkConfig);
        this.setAuthenticationSchemes(authenticationSchemes);
        Meta meta = Meta.builder().resourceType("ServiceProviderConfig").created(LocalDateTime.now()).lastModified(LocalDateTime.now()).build();
        this.setMeta(meta);
        Optional.ofNullable(forkJoinPool).ifPresent(this::setThreadPool);
    }

    public Optional<String> getDocumentationUri() {
        return this.getStringAttribute("documentationUri");
    }

    public void setDocumentationUri(String documentationUri) {
        this.setAttribute("documentationUri", documentationUri);
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public PatchConfig getPatchConfig() {
        return this.getObjectAttribute("patch", PatchConfig.class).orElse(PatchConfig.builder().build());
    }

    public void setPatchConfig(PatchConfig patchConfig) {
        this.setAttribute("patch", Optional.ofNullable(patchConfig).orElse(PatchConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public BulkConfig getBulkConfig() {
        return this.getObjectAttribute("bulk", BulkConfig.class).orElse(BulkConfig.builder().build());
    }

    public void setBulkConfig(BulkConfig bulkConfig) {
        this.setAttribute("bulk", Optional.ofNullable(bulkConfig).orElse(BulkConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public FilterConfig getFilterConfig() {
        return this.getObjectAttribute("filter", FilterConfig.class).orElse(FilterConfig.builder().build());
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.setAttribute("filter", Optional.ofNullable(filterConfig).orElse(FilterConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public ChangePasswordConfig getChangePasswordConfig() {
        return this.getObjectAttribute("changePassword", ChangePasswordConfig.class).orElse(ChangePasswordConfig.builder().build());
    }

    public void setChangePasswordConfig(ChangePasswordConfig changePasswordConfig) {
        this.setAttribute("changePassword", Optional.ofNullable(changePasswordConfig).orElse(ChangePasswordConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public SortConfig getSortConfig() {
        return this.getObjectAttribute("sort", SortConfig.class).orElse(SortConfig.builder().build());
    }

    public void setSortConfig(SortConfig sortConfig) {
        this.setAttribute("sort", Optional.ofNullable(sortConfig).orElse(SortConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public ETagConfig getETagConfig() {
        return this.getObjectAttribute("etag", ETagConfig.class).orElse(ETagConfig.builder().build());
    }

    public void setETagConfig(ETagConfig eTagConfig) {
        this.setAttribute("etag", Optional.ofNullable(eTagConfig).orElse(ETagConfig.builder().build()));
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public List<AuthenticationScheme> getAuthenticationSchemes() {
        return this.getArrayAttribute("authenticationSchemes", AuthenticationScheme.class);
    }

    public void setAuthenticationSchemes(List<AuthenticationScheme> authenticationSchemes) {
        if (authenticationSchemes == null || authenticationSchemes.isEmpty()) {
            log.error("No authentication scheme has been set, this will cause a DocumentValidationException on the '/ServiceProviderConfig' endpoint!");
        }
        this.setAttribute("authenticationSchemes", authenticationSchemes);
        this.getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
    }

    public void setThreadPool(ForkJoinPool threadPool) {
        this.threadPool = Objects.requireNonNull(threadPool);
    }

    public static ServiceProviderBuilder builder() {
        return new ServiceProviderBuilder();
    }

    public ServiceProvider() {
    }

    public ForkJoinPool getThreadPool() {
        return this.threadPool;
    }

    public static class ServiceProviderBuilder {
        private String documentationUri;
        private PatchConfig patchConfig;
        private ChangePasswordConfig changePasswordConfig;
        private SortConfig sortConfig;
        private ETagConfig eTagConfig;
        private FilterConfig filterConfig;
        private BulkConfig bulkConfig;
        private List<AuthenticationScheme> authenticationSchemes;
        private ForkJoinPool forkJoinPool;

        ServiceProviderBuilder() {
        }

        public ServiceProviderBuilder documentationUri(String documentationUri) {
            this.documentationUri = documentationUri;
            return this;
        }

        public ServiceProviderBuilder patchConfig(PatchConfig patchConfig) {
            this.patchConfig = patchConfig;
            return this;
        }

        public ServiceProviderBuilder changePasswordConfig(ChangePasswordConfig changePasswordConfig) {
            this.changePasswordConfig = changePasswordConfig;
            return this;
        }

        public ServiceProviderBuilder sortConfig(SortConfig sortConfig) {
            this.sortConfig = sortConfig;
            return this;
        }

        public ServiceProviderBuilder eTagConfig(ETagConfig eTagConfig) {
            this.eTagConfig = eTagConfig;
            return this;
        }

        public ServiceProviderBuilder filterConfig(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
            return this;
        }

        public ServiceProviderBuilder bulkConfig(BulkConfig bulkConfig) {
            this.bulkConfig = bulkConfig;
            return this;
        }

        public ServiceProviderBuilder authenticationSchemes(List<AuthenticationScheme> authenticationSchemes) {
            this.authenticationSchemes = authenticationSchemes;
            return this;
        }

        public ServiceProviderBuilder forkJoinPool(ForkJoinPool forkJoinPool) {
            this.forkJoinPool = forkJoinPool;
            return this;
        }

        public ServiceProvider build() {
            return new ServiceProvider(this.documentationUri, this.patchConfig, this.changePasswordConfig, this.sortConfig, this.eTagConfig, this.filterConfig, this.bulkConfig, this.authenticationSchemes, this.forkJoinPool);
        }

        public String toString() {
            return "ServiceProvider.ServiceProviderBuilder(documentationUri=" + this.documentationUri + ", patchConfig=" + this.patchConfig + ", changePasswordConfig=" + this.changePasswordConfig + ", sortConfig=" + this.sortConfig + ", eTagConfig=" + this.eTagConfig + ", filterConfig=" + this.filterConfig + ", bulkConfig=" + this.bulkConfig + ", authenticationSchemes=" + this.authenticationSchemes + ", forkJoinPool=" + this.forkJoinPool + ")";
        }
    }
}

