// Generated by delombok at Sat Sep 11 10:35:16 CEST 2021
package de.captaingoldfish.scim.sdk.common.resources;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import de.captaingoldfish.scim.sdk.common.constants.AttributeNames;
import de.captaingoldfish.scim.sdk.common.constants.ResourceTypeNames;
import de.captaingoldfish.scim.sdk.common.constants.SchemaUris;
import de.captaingoldfish.scim.sdk.common.resources.complex.BulkConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ChangePasswordConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.ETagConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.FilterConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.Meta;
import de.captaingoldfish.scim.sdk.common.resources.complex.PatchConfig;
import de.captaingoldfish.scim.sdk.common.resources.complex.SortConfig;
import de.captaingoldfish.scim.sdk.common.resources.multicomplex.AuthenticationScheme;


/**
 * author Pascal Knueppel <br>
 * created at: 18.10.2019 - 09:39 <br>
 * <br>
 * SCIM provides a schema for representing the service provider's configuration, identified using the
 * following schema URI: "urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig". The service provider
 * configuration resource enables a service provider to discover SCIM specification features in a standardized
 * form as well as provide additional implementation details to clients. All attributes have a mutability of
 * "readOnly". Unlike other core resources, the "id" attribute is not required for the service provider
 * configuration resource.
 */
public class ServiceProvider extends ResourceNode
{

  @java.lang.SuppressWarnings("all")
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ServiceProvider.class);

  /**
   * this thread pool can be set to override the default thread pool when resources are auto-sorted or
   * auto-filtered
   */
  private ForkJoinPool threadPool = ForkJoinPool.commonPool();

  public ServiceProvider(String documentationUri,
                         PatchConfig patchConfig,
                         ChangePasswordConfig changePasswordConfig,
                         SortConfig sortConfig,
                         ETagConfig eTagConfig,
                         FilterConfig filterConfig,
                         BulkConfig bulkConfig,
                         List<AuthenticationScheme> authenticationSchemes,
                         ForkJoinPool forkJoinPool)
  {
    setSchemas(Arrays.asList(SchemaUris.SERVICE_PROVIDER_CONFIG_URI));
    setDocumentationUri(documentationUri);
    setPatchConfig(patchConfig);
    setChangePasswordConfig(changePasswordConfig);
    setSortConfig(sortConfig);
    setETagConfig(eTagConfig);
    setFilterConfig(filterConfig);
    setBulkConfig(bulkConfig);
    setAuthenticationSchemes(authenticationSchemes);
    Meta meta = Meta.builder()
                    .resourceType(ResourceTypeNames.SERVICE_PROVIDER_CONFIG)
                    .created(LocalDateTime.now())
                    .lastModified(LocalDateTime.now())
                    .build();
    setMeta(meta);
    Optional.ofNullable(forkJoinPool).ifPresent(this::setThreadPool);
  }

  /**
   * An HTTP-addressable URL pointing to the service provider's human-consumable help documentation. OPTIONAL.
   */
  public Optional<String> getDocumentationUri()
  {
    return getStringAttribute(AttributeNames.RFC7643.DOCUMENTATION_URI);
  }

  /**
   * An HTTP-addressable URL pointing to the service provider's human-consumable help documentation. OPTIONAL.
   */
  public void setDocumentationUri(String documentationUri)
  {
    setAttribute(AttributeNames.RFC7643.DOCUMENTATION_URI, documentationUri);
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies PATCH configuration options. REQUIRED. See Section 3.5.2 of [RFC7644].
   */
  public PatchConfig getPatchConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.PATCH, PatchConfig.class).orElse(PatchConfig.builder().build());
  }

  /**
   * A complex type that specifies PATCH configuration options. REQUIRED. See Section 3.5.2 of [RFC7644].
   */
  public void setPatchConfig(PatchConfig patchConfig)
  {
    setAttribute(AttributeNames.RFC7643.PATCH, Optional.ofNullable(patchConfig).orElse(PatchConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies bulk configuration options. See Section 3.7 of [RFC7644]. REQUIRED.
   */
  public BulkConfig getBulkConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.BULK, BulkConfig.class).orElse(BulkConfig.builder().build());
  }

  /**
   * A complex type that specifies bulk configuration options. See Section 3.7 of [RFC7644]. REQUIRED.
   */
  public void setBulkConfig(BulkConfig bulkConfig)
  {
    setAttribute(AttributeNames.RFC7643.BULK, Optional.ofNullable(bulkConfig).orElse(BulkConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies FILTER options. REQUIRED. See Section 3.4.2.2 of [RFC7644].
   */
  public FilterConfig getFilterConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.FILTER, FilterConfig.class).orElse(FilterConfig.builder().build());
  }

  /**
   * A complex type that specifies FILTER options. REQUIRED. See Section 3.4.2.2 of [RFC7644].
   */
  public void setFilterConfig(FilterConfig filterConfig)
  {
    setAttribute(AttributeNames.RFC7643.FILTER,
                 Optional.ofNullable(filterConfig).orElse(FilterConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies configuration options related to changing a password. REQUIRED.
   */
  public ChangePasswordConfig getChangePasswordConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.CHANGE_PASSWORD,
                              ChangePasswordConfig.class).orElse(ChangePasswordConfig.builder().build());
  }

  /**
   * A complex type that specifies configuration options related to changing a password. REQUIRED.
   */
  public void setChangePasswordConfig(ChangePasswordConfig changePasswordConfig)
  {
    setAttribute(AttributeNames.RFC7643.CHANGE_PASSWORD,
                 Optional.ofNullable(changePasswordConfig).orElse(ChangePasswordConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies Sort configuration options. REQUIRED.
   */
  public SortConfig getSortConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.SORT, SortConfig.class).orElse(SortConfig.builder().build());
  }

  /**
   * A complex type that specifies Sort configuration options. REQUIRED.
   */
  public void setSortConfig(SortConfig sortConfig)
  {
    setAttribute(AttributeNames.RFC7643.SORT, Optional.ofNullable(sortConfig).orElse(SortConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A complex type that specifies ETag configuration options. REQUIRED.
   */
  public ETagConfig getETagConfig()
  {
    return getObjectAttribute(AttributeNames.RFC7643.ETAG, ETagConfig.class).orElse(ETagConfig.builder().build());
  }

  /**
   * A complex type that specifies ETag configuration options. REQUIRED.
   */
  public void setETagConfig(ETagConfig eTagConfig)
  {
    setAttribute(AttributeNames.RFC7643.ETAG, Optional.ofNullable(eTagConfig).orElse(ETagConfig.builder().build()));
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * A multi-valued complex type that specifies supported authentication scheme properties. To enable seamless
   * discovery of configurations, the service provider SHOULD, with the appropriate security considerations,
   * make the authenticationSchemes attribute publicly accessible without prior authentication. REQUIRED.
   */
  public List<AuthenticationScheme> getAuthenticationSchemes()
  {
    return getArrayAttribute(AttributeNames.RFC7643.AUTHENTICATION_SCHEMES, AuthenticationScheme.class);
  }

  /**
   * A multi-valued complex type that specifies supported authentication scheme properties. To enable seamless
   * discovery of configurations, the service provider SHOULD, with the appropriate security considerations,
   * make the authenticationSchemes attribute publicly accessible without prior authentication. REQUIRED.
   */
  public void setAuthenticationSchemes(List<AuthenticationScheme> authenticationSchemes)
  {
    if (authenticationSchemes == null || authenticationSchemes.isEmpty())
    {
      log.error("No authentication scheme has been set, this will cause a DocumentValidationException on the "
                + "\'/ServiceProviderConfig\' endpoint!");
    }
    setAttribute(AttributeNames.RFC7643.AUTHENTICATION_SCHEMES, authenticationSchemes);
    getMeta().ifPresent(meta -> meta.setLastModified(LocalDateTime.now()));
  }

  /**
   * @see #threadPool
   */
  public void setThreadPool(ForkJoinPool threadPool)
  {
    this.threadPool = Objects.requireNonNull(threadPool);
  }


  @java.lang.SuppressWarnings("all")
  public static class ServiceProviderBuilder
  {

    @java.lang.SuppressWarnings("all")
    private String documentationUri;

    @java.lang.SuppressWarnings("all")
    private PatchConfig patchConfig;

    @java.lang.SuppressWarnings("all")
    private ChangePasswordConfig changePasswordConfig;

    @java.lang.SuppressWarnings("all")
    private SortConfig sortConfig;

    @java.lang.SuppressWarnings("all")
    private ETagConfig eTagConfig;

    @java.lang.SuppressWarnings("all")
    private FilterConfig filterConfig;

    @java.lang.SuppressWarnings("all")
    private BulkConfig bulkConfig;

    @java.lang.SuppressWarnings("all")
    private List<AuthenticationScheme> authenticationSchemes;

    @java.lang.SuppressWarnings("all")
    private ForkJoinPool forkJoinPool;

    @java.lang.SuppressWarnings("all")
    ServiceProviderBuilder()
    {}

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder documentationUri(final String documentationUri)
    {
      this.documentationUri = documentationUri;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder patchConfig(final PatchConfig patchConfig)
    {
      this.patchConfig = patchConfig;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder changePasswordConfig(final ChangePasswordConfig changePasswordConfig)
    {
      this.changePasswordConfig = changePasswordConfig;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder sortConfig(final SortConfig sortConfig)
    {
      this.sortConfig = sortConfig;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder eTagConfig(final ETagConfig eTagConfig)
    {
      this.eTagConfig = eTagConfig;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder filterConfig(final FilterConfig filterConfig)
    {
      this.filterConfig = filterConfig;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder bulkConfig(final BulkConfig bulkConfig)
    {
      this.bulkConfig = bulkConfig;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder authenticationSchemes(final List<AuthenticationScheme> authenticationSchemes)
    {
      this.authenticationSchemes = authenticationSchemes;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public ServiceProvider.ServiceProviderBuilder forkJoinPool(final ForkJoinPool forkJoinPool)
    {
      this.forkJoinPool = forkJoinPool;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public ServiceProvider build()
    {
      return new ServiceProvider(this.documentationUri, this.patchConfig, this.changePasswordConfig, this.sortConfig,
                                 this.eTagConfig, this.filterConfig, this.bulkConfig, this.authenticationSchemes,
                                 this.forkJoinPool);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString()
    {
      return "ServiceProvider.ServiceProviderBuilder(documentationUri=" + this.documentationUri + ", patchConfig="
             + this.patchConfig + ", changePasswordConfig=" + this.changePasswordConfig + ", sortConfig="
             + this.sortConfig + ", eTagConfig=" + this.eTagConfig + ", filterConfig=" + this.filterConfig
             + ", bulkConfig=" + this.bulkConfig + ", authenticationSchemes=" + this.authenticationSchemes
             + ", forkJoinPool=" + this.forkJoinPool + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static ServiceProvider.ServiceProviderBuilder builder()
  {
    return new ServiceProvider.ServiceProviderBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public ServiceProvider()
  {}

  /**
   * this thread pool can be set to override the default thread pool when resources are auto-sorted or
   * auto-filtered
   */
  @java.lang.SuppressWarnings("all")
  public ForkJoinPool getThreadPool()
  {
    return this.threadPool;
  }
}
