/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.request;

import com.fasterxml.jackson.databind.node.ObjectNode;
import de.captaingoldfish.scim.sdk.common.request.BulkRequestOperation;
import de.captaingoldfish.scim.sdk.common.resources.AbstractSchemasHolder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class BulkRequest
extends AbstractSchemasHolder {
    public BulkRequest() {
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:BulkRequest"));
    }

    public BulkRequest(Integer failOnErrors, List<BulkRequestOperation> bulkRequestOperation) {
        this();
        this.setFailOnErrors(failOnErrors);
        this.setBulkRequestOperations(bulkRequestOperation);
    }

    public Optional<Integer> getFailOnErrors() {
        return this.getLongAttribute("failOnErrors").map(Long::intValue);
    }

    public void setFailOnErrors(Integer failOnErrors) {
        this.setAttribute("failOnErrors", failOnErrors == null ? null : Long.valueOf(failOnErrors.longValue()));
    }

    public List<BulkRequestOperation> getBulkRequestOperations() {
        List<BulkRequestOperation> operations = this.getArrayAttribute("Operations", BulkRequestOperation.class);
        if (operations.isEmpty()) {
            this.setAttribute("Operations", (ObjectNode)null);
        }
        return operations;
    }

    public void setBulkRequestOperations(List<BulkRequestOperation> bulkRequestOperation) {
        this.setAttribute("Operations", bulkRequestOperation);
    }

    public static BulkRequestBuilder builder() {
        return new BulkRequestBuilder();
    }

    public static class BulkRequestBuilder {
        private Integer failOnErrors;
        private List<BulkRequestOperation> bulkRequestOperation;

        public BulkRequestBuilder failOnErrors(Integer failOnErrors) {
            this.failOnErrors = failOnErrors;
            return this;
        }

        public BulkRequestBuilder bulkRequestOperation(List<BulkRequestOperation> bulkRequestOperation) {
            this.bulkRequestOperation = bulkRequestOperation;
            return this;
        }

        public BulkRequest build() {
            return new BulkRequest(this.failOnErrors, this.bulkRequestOperation);
        }

        public String toString() {
            return "BulkRequest.BulkRequestBuilder(failOnErrors=" + this.failOnErrors + ", bulkRequestOperation=" + this.bulkRequestOperation + ")";
        }
    }
}

