/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.request;

import de.captaingoldfish.scim.sdk.common.constants.enums.SortOrder;
import de.captaingoldfish.scim.sdk.common.resources.AbstractSchemasHolder;
import java.util.Collections;
import java.util.Optional;

public class SearchRequest
extends AbstractSchemasHolder {
    public SearchRequest() {
        this(null, null, null, null, null, null, null);
    }

    public SearchRequest(Long startIndex, Integer count, String filter, String sortBy, SortOrder sortOrder, String attributes, String excludedAttributes) {
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:SearchRequest"));
        this.setStartIndex(startIndex);
        this.setCount(count);
        this.setFilter(filter);
        this.setSortBy(sortBy);
        this.setSortOrder(sortOrder);
        this.setAttributes(attributes);
        this.setExcludedAttributes(excludedAttributes);
    }

    public Optional<Long> getStartIndex() {
        return this.getLongAttribute("startIndex");
    }

    public void setStartIndex(Long startIndex) {
        this.setAttribute("startIndex", startIndex);
    }

    public Optional<Integer> getCount() {
        return this.getLongAttribute("count").map(Long::intValue);
    }

    public void setCount(Integer count) {
        this.setAttribute("count", count == null ? null : Long.valueOf(count.intValue()));
    }

    public Optional<String> getFilter() {
        return this.getStringAttribute("filter");
    }

    public void setFilter(String filter) {
        this.setAttribute("filter", filter);
    }

    public Optional<String> getSortBy() {
        return this.getStringAttribute("sortBy");
    }

    public void setSortBy(String sortBy) {
        this.setAttribute("sortBy", sortBy);
    }

    public Optional<String> getSortOrder() {
        return this.getStringAttribute("sortOrder");
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.setAttribute("sortOrder", (String)Optional.ofNullable(sortOrder).map(order -> order.name().toLowerCase()).orElse(null));
    }

    public Optional<String> getAttributes() {
        return this.getStringAttribute("attributes");
    }

    public void setAttributes(String attributes) {
        this.setAttribute("attributes", attributes);
    }

    public Optional<String> getExcludedAttributes() {
        return this.getStringAttribute("excludedAttributes");
    }

    public void setExcludedAttributes(String excludedAttributes) {
        this.setAttribute("excludedAttributes", excludedAttributes);
    }

    public static SearchRequestBuilder builder() {
        return new SearchRequestBuilder();
    }

    public static class SearchRequestBuilder {
        private Long startIndex;
        private Integer count;
        private String filter;
        private String sortBy;
        private SortOrder sortOrder;
        private String attributes;
        private String excludedAttributes;

        public SearchRequestBuilder startIndex(Long startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public SearchRequestBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public SearchRequestBuilder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public SearchRequestBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public SearchRequestBuilder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public SearchRequestBuilder attributes(String attributes) {
            this.attributes = attributes;
            return this;
        }

        public SearchRequestBuilder excludedAttributes(String excludedAttributes) {
            this.excludedAttributes = excludedAttributes;
            return this;
        }

        public SearchRequest build() {
            return new SearchRequest(this.startIndex, this.count, this.filter, this.sortBy, this.sortOrder, this.attributes, this.excludedAttributes);
        }

        public String toString() {
            return "SearchRequest.SearchRequestBuilder(startIndex=" + this.startIndex + ", count=" + this.count + ", filter=" + this.filter + ", sortBy=" + this.sortBy + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", attributes=" + this.attributes + ", excludedAttributes=" + this.excludedAttributes + ")";
        }
    }
}

