/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.response;

import com.fasterxml.jackson.databind.JsonNode;
import de.captaingoldfish.scim.sdk.common.response.BulkResponseOperation;
import de.captaingoldfish.scim.sdk.common.response.ScimResponse;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BulkResponse
extends ScimResponse {
    private int httpStatus;

    public BulkResponse(List<BulkResponseOperation> bulkResponseOperation, int httpStatus) {
        this();
        this.setBulkResponseOperations(bulkResponseOperation);
        this.httpStatus = httpStatus;
    }

    public BulkResponse() {
        super((JsonNode)null);
        this.setSchemas(Collections.singletonList("urn:ietf:params:scim:api:messages:2.0:BulkResponse"));
    }

    @Override
    public int getHttpStatus() {
        return this.httpStatus;
    }

    public List<BulkResponseOperation> getBulkResponseOperations() {
        List<BulkResponseOperation> operations = this.getArrayAttribute("Operations", BulkResponseOperation.class);
        if (operations.isEmpty()) {
            this.setAttribute("Operations", operations);
        }
        return operations;
    }

    public void setBulkResponseOperations(List<BulkResponseOperation> bulkRequestOperations) {
        this.setAttribute("Operations", bulkRequestOperations);
    }

    public Optional<BulkResponseOperation> getByBulkId(String bulkId) {
        return this.getBulkResponseOperations().stream().filter(arg_0 -> BulkResponse.lambda$getByBulkId$0(bulkId, arg_0)).findFirst();
    }

    public List<BulkResponseOperation> getOperationsWithBulkId() {
        return this.getBulkResponseOperations().stream().filter(op -> op.getBulkId().isPresent()).collect(Collectors.toList());
    }

    public List<BulkResponseOperation> getOperationsWithoutBulkId() {
        return this.getBulkResponseOperations().stream().filter(op -> !op.getBulkId().isPresent()).collect(Collectors.toList());
    }

    public static BulkResponseBuilder builder() {
        return new BulkResponseBuilder();
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$getByBulkId$0(String bulkId, BulkResponseOperation op) {
        v0 = isNullMatch = op.getBulkId().isPresent() == false && bulkId == null;
        if (bulkId == null) ** GOTO lbl-1000
        if (op.getBulkId().map((Function<String, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, equals(java.lang.Object ), (Ljava/lang/String;)Ljava/lang/Boolean;)((String)bulkId)).orElse(false).booleanValue()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isBulkIdMatch = v1;
        return isNullMatch != false || isBulkIdMatch != false;
    }

    public static class BulkResponseBuilder {
        private List<BulkResponseOperation> bulkResponseOperation;
        private int httpStatus;

        public BulkResponseBuilder bulkResponseOperation(List<BulkResponseOperation> bulkResponseOperation) {
            this.bulkResponseOperation = bulkResponseOperation;
            return this;
        }

        public BulkResponseBuilder httpStatus(int httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public BulkResponse build() {
            return new BulkResponse(this.bulkResponseOperation, this.httpStatus);
        }

        public String toString() {
            return "BulkResponse.BulkResponseBuilder(bulkResponseOperation=" + this.bulkResponseOperation + ", httpStatus=" + this.httpStatus + ")";
        }
    }
}

