/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.request;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.captaingoldfish.scim.sdk.common.constants.enums.PatchOp;
import de.captaingoldfish.scim.sdk.common.exceptions.IOException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimObjectNode;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class PatchRequestOperation
extends ScimObjectNode {
    public PatchRequestOperation(String path, PatchOp op, List<String> values, JsonNode valueNode) {
        this();
        this.setPath(path);
        this.setOp(op);
        if (values == null || values.isEmpty()) {
            this.setValueNode(valueNode);
        } else {
            this.setValues(values);
        }
    }

    public Optional<String> getPath() {
        return this.getStringAttribute("path");
    }

    public void setPath(String path) {
        this.setAttribute("path", path);
    }

    public PatchOp getOp() {
        return this.getStringAttribute("op").map(PatchOp::getByValue).orElse(null);
    }

    public void setOp(PatchOp patchOp) {
        this.setAttribute("op", patchOp == null ? null : patchOp.getValue());
    }

    public List<String> getValues() {
        return this.getSimpleArrayAttribute("value");
    }

    public void setValues(List<String> value) {
        if (value == null || value.size() > 1) {
            this.setAttributeList("value", value);
        } else if (value.size() == 1) {
            this.setAttribute("value", value.get(0));
        } else {
            this.setAttribute("value", (String)null);
        }
    }

    public Optional<ArrayNode> getValueNode() {
        Object jsonNode = this.get("value");
        if (jsonNode == null) {
            return Optional.empty();
        }
        if (jsonNode.isTextual()) {
            try {
                jsonNode = JsonHelper.readJsonDocument(jsonNode.textValue(), ScimObjectNode.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setValueNode((JsonNode)jsonNode);
        }
        if (jsonNode.isObject()) {
            this.setValueNode((JsonNode)jsonNode);
        }
        return Optional.of((ArrayNode)this.get("value"));
    }

    public void setValueNode(JsonNode value) {
        this.setAttribute("value", value == null ? null : Collections.singletonList(value));
    }

    public static PatchRequestOperationBuilder builder() {
        return new PatchRequestOperationBuilder();
    }

    public PatchRequestOperation() {
    }

    public static class PatchRequestOperationBuilder {
        private String path;
        private PatchOp op;
        private List<String> values;
        private JsonNode valueNode;

        public PatchRequestOperationBuilder value(String value) {
            this.values(Arrays.asList(value));
            return this;
        }

        public PatchRequestOperationBuilder path(String path) {
            this.path = path;
            return this;
        }

        public PatchRequestOperationBuilder op(PatchOp op) {
            this.op = op;
            return this;
        }

        public PatchRequestOperationBuilder values(List<String> values) {
            this.values = values;
            return this;
        }

        public PatchRequestOperationBuilder valueNode(JsonNode valueNode) {
            this.valueNode = valueNode;
            return this;
        }

        public PatchRequestOperation build() {
            return new PatchRequestOperation(this.path, this.op, this.values, this.valueNode);
        }

        public String toString() {
            return "PatchRequestOperation.PatchRequestOperationBuilder(path=" + this.path + ", op=" + (Object)((Object)this.op) + ", values=" + this.values + ", valueNode=" + this.valueNode + ")";
        }
    }
}

