/*
 * Decompiled with CFR 0.152.
 */
package de.captaingoldfish.scim.sdk.common.resources.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.captaingoldfish.scim.sdk.common.exceptions.IncompatibleAttributeException;
import de.captaingoldfish.scim.sdk.common.exceptions.InternalServerException;
import de.captaingoldfish.scim.sdk.common.resources.base.ScimNode;
import de.captaingoldfish.scim.sdk.common.schemas.SchemaAttribute;
import de.captaingoldfish.scim.sdk.common.utils.JsonHelper;
import de.captaingoldfish.scim.sdk.common.utils.TimeUtils;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ScimObjectNode
extends ObjectNode
implements ScimNode {
    private SchemaAttribute schemaAttribute;

    public ScimObjectNode() {
        super(JsonNodeFactory.instance);
    }

    public ScimObjectNode(SchemaAttribute schemaAttribute) {
        this();
        this.schemaAttribute = schemaAttribute;
    }

    protected Optional<String> getStringAttribute(String attributeName) {
        return JsonHelper.getSimpleAttribute((JsonNode)this, attributeName);
    }

    protected Optional<byte[]> getBinaryAttribute(String attributeName) {
        return JsonHelper.getSimpleAttribute((JsonNode)this, attributeName, byte[].class);
    }

    protected Optional<Boolean> getBooleanAttribute(String attributeName) {
        return JsonHelper.getSimpleAttribute((JsonNode)this, attributeName, Boolean.class);
    }

    protected Optional<Long> getLongAttribute(String attributeName) {
        return JsonHelper.getSimpleAttribute((JsonNode)this, attributeName, Long.class);
    }

    protected Optional<Integer> getIntegerAttribute(String attributeName) {
        return JsonHelper.getSimpleAttribute((JsonNode)this, attributeName, Integer.class);
    }

    protected Optional<Double> getDoubleAttribute(String attributeName) {
        return JsonHelper.getSimpleAttribute((JsonNode)this, attributeName, Double.class);
    }

    protected Optional<Instant> getDateTimeAttribute(String attributeName) {
        String dateTime = JsonHelper.getSimpleAttribute((JsonNode)this, attributeName).orElse(null);
        return Optional.ofNullable(TimeUtils.parseDateTime(dateTime));
    }

    protected <T extends TextNode> Optional<T> getStringAttribute(String attributeName, Class<T> type) {
        JsonNode jsonNode = this.get(attributeName);
        if (jsonNode == null || jsonNode.isNull()) {
            return Optional.empty();
        }
        if (!(jsonNode instanceof TextNode)) {
            throw new InternalServerException("tried to extract a string node from document with attribute name '" + attributeName + "' but type is of: " + jsonNode.getNodeType(), null, null);
        }
        if (type.isAssignableFrom(jsonNode.getClass())) {
            return Optional.of((TextNode)jsonNode);
        }
        try {
            TextNode t = (TextNode)type.getMethod("newInstance", String.class).invoke(null, jsonNode.textValue());
            this.set(attributeName, (JsonNode)t);
            return Optional.of(t);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new InternalServerException(e.getMessage(), e, null);
        }
    }

    protected <T extends ObjectNode> Optional<T> getObjectAttribute(String attributeName, Class<T> type) {
        JsonNode jsonNode = this.get(attributeName);
        if (jsonNode == null || jsonNode.isNull()) {
            return Optional.empty();
        }
        if (!(jsonNode instanceof ObjectNode)) {
            throw new InternalServerException("tried to extract a complex node from document with attribute name '" + attributeName + "' but type is of: " + jsonNode.getNodeType(), null, null);
        }
        if (type.isAssignableFrom(jsonNode.getClass())) {
            return Optional.of((ObjectNode)jsonNode);
        }
        T t = JsonHelper.copyResourceToObject(jsonNode, type);
        this.set(attributeName, (JsonNode)t);
        return Optional.of(t);
    }

    protected <T extends ObjectNode> List<T> getArrayAttribute(String attributeName, Class<T> type) {
        JsonNode jsonNode = this.get(attributeName);
        if (jsonNode == null || jsonNode.isNull()) {
            return new ArrayList();
        }
        if (!(jsonNode instanceof ArrayNode)) {
            throw new InternalServerException("tried to extract a multi valued complex node from document with attribute name '" + attributeName + "' but type is of: " + jsonNode.getNodeType(), null, null);
        }
        ArrayList<Object> multiValuedComplexTypes = new ArrayList<Object>();
        boolean shouldBeReplaced = false;
        for (JsonNode node : jsonNode) {
            if (!(node instanceof ObjectNode)) {
                throw new InternalServerException("tried to extract a complex node from document with attribute name '" + attributeName + "' but type is of: " + jsonNode.getNodeType(), null, null);
            }
            if (type.isAssignableFrom(node.getClass())) {
                multiValuedComplexTypes.add((ObjectNode)node);
                continue;
            }
            shouldBeReplaced = true;
            T t = JsonHelper.copyResourceToObject(node, type);
            multiValuedComplexTypes.add(t);
        }
        if (shouldBeReplaced) {
            this.setAttribute(attributeName, multiValuedComplexTypes);
        }
        return multiValuedComplexTypes;
    }

    protected List<String> getSimpleArrayAttribute(String attributeName) {
        return this.getSimpleArrayAttribute(attributeName, String.class);
    }

    protected <T> List<T> getSimpleArrayAttribute(String attributeName, Class<T> type) {
        if (!Arrays.asList(Long.class, Double.class, Boolean.class, String.class, Instant.class, byte[].class).contains(type)) {
            throw new InternalServerException("the type '" + type.getSimpleName() + "' is not allowed for this method", null, null);
        }
        JsonNode jsonNode = this.get(attributeName);
        if (jsonNode == null || jsonNode.isNull()) {
            return new ArrayList();
        }
        if (!(jsonNode instanceof ArrayNode)) {
            if (jsonNode instanceof ObjectNode) {
                throw new InternalServerException("tried to extract a multi valued complex node from document with attribute name '" + attributeName + "' but type is of: " + jsonNode.getNodeType(), null, null);
            }
            ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
            arrayNode.add(jsonNode);
            jsonNode = arrayNode;
        }
        ArrayList<Object> multiValuedSimpleTypes = new ArrayList<Object>();
        for (JsonNode node : jsonNode) {
            if (Long.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.longValue());
                continue;
            }
            if (Double.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.doubleValue());
                continue;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.booleanValue());
                continue;
            }
            if (String.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.isTextual() ? node.textValue() : node.toString());
                continue;
            }
            if (byte[].class.isAssignableFrom(type)) {
                try {
                    multiValuedSimpleTypes.add(Base64.getDecoder().decode(node.asText()));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    throw new IncompatibleAttributeException(String.format("The value of node with name '%s' is not of type binary. Illegal base64 encoded data", attributeName), (Throwable)ex, null, "invalidValue");
                }
            }
            multiValuedSimpleTypes.add(TimeUtils.parseDateTime(node.textValue()));
        }
        return multiValuedSimpleTypes;
    }

    protected Set<String> getSimpleArrayAttributeSet(String attributeName) {
        return this.getSimpleArrayAttributeSet(attributeName, String.class);
    }

    protected <T> Set<T> getSimpleArrayAttributeSet(String attributeName, Class<T> type) {
        if (!Arrays.asList(Long.class, Double.class, Boolean.class, String.class, Instant.class).contains(type)) {
            throw new InternalServerException("the type '" + type.getSimpleName() + "' is not allowed for this method", null, null);
        }
        JsonNode jsonNode = this.get(attributeName);
        if (jsonNode == null || jsonNode.isNull()) {
            return new HashSet();
        }
        if (!(jsonNode instanceof ArrayNode)) {
            throw new InternalServerException("tried to extract a multi valued complex node from document with attribute name '" + attributeName + "' but type is of: " + jsonNode.getNodeType(), null, null);
        }
        HashSet<Object> multiValuedSimpleTypes = new HashSet<Object>();
        for (JsonNode node : jsonNode) {
            if (Long.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.longValue());
                continue;
            }
            if (Double.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.doubleValue());
                continue;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.booleanValue());
                continue;
            }
            if (String.class.isAssignableFrom(type)) {
                multiValuedSimpleTypes.add(node.isTextual() ? node.textValue() : node.toString());
                continue;
            }
            multiValuedSimpleTypes.add(TimeUtils.parseDateTime(node.textValue()));
        }
        return multiValuedSimpleTypes;
    }

    protected void setAttribute(String attributeName, String attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)new TextNode(attributeValue));
    }

    protected void setAttribute(String attributeName, byte[] attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)new BinaryNode(attributeValue));
    }

    protected void setAttribute(String attributeName, Boolean attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)BooleanNode.valueOf((boolean)attributeValue));
    }

    protected void setAttribute(String attributeName, Long attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        if (attributeValue == (long)attributeValue.intValue()) {
            JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)new IntNode(attributeValue.intValue()));
        } else {
            JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)new LongNode(attributeValue.longValue()));
        }
    }

    protected void setAttribute(String attributeName, Integer attributeValue) {
        this.setAttribute(attributeName, attributeValue == null ? null : Long.valueOf(attributeValue.longValue()));
    }

    protected void setAttribute(String attributeName, Double attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)new DoubleNode(attributeValue.doubleValue()));
    }

    protected void setDateTimeAttribute(String attributeName, Instant attributeValue) {
        this.setDateTimeAttribute(attributeName, attributeValue, 3);
    }

    protected void setDateTimeAttribute(String attributeName, Instant attributeValue, int fractionalDigits) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendInstant(fractionalDigits).toFormatter();
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)new TextNode(formatter.format(attributeValue)));
    }

    protected void setDateTimeAttribute(String attributeName, LocalDateTime attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        ZoneOffset zoneOffset = OffsetDateTime.now().getOffset();
        this.setDateTimeAttribute(attributeName, attributeValue.atOffset(zoneOffset));
    }

    protected void setDateTimeAttribute(String attributeName, OffsetDateTime attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        String dateTime = attributeValue.format(DateTimeFormatter.ISO_DATE_TIME);
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)new TextNode(dateTime));
    }

    protected void setAttribute(String attributeName, ObjectNode attributeValue) {
        if (attributeValue == null) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)attributeValue);
    }

    protected <T extends JsonNode> void setAttribute(String attributeName, List<T> attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        for (JsonNode jsonNodes : attributeValue) {
            if (jsonNodes == null) continue;
            if (jsonNodes.isArray()) {
                arrayNode.addAll((ArrayNode)jsonNodes);
                continue;
            }
            arrayNode.add(jsonNodes);
        }
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)arrayNode);
    }

    protected void setStringAttributeList(String attributeName, List<String> attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        attributeValue.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)arrayNode);
    }

    protected void setStringAttributeList(String attributeName, Set<String> attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        attributeValue.forEach(arg_0 -> ((ArrayNode)arrayNode).add(arg_0));
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)arrayNode);
    }

    protected <T> void setAttributeList(String attributeName, List<T> attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            JsonHelper.removeAttribute((JsonNode)this, attributeName);
            return;
        }
        Class<?> type = attributeValue.stream().filter(Objects::nonNull).findAny().orElse("").getClass();
        if (!Arrays.asList(Long.class, Double.class, Boolean.class, String.class, Instant.class, byte[].class).contains(type)) {
            throw new InternalServerException("the type '" + type.getSimpleName() + "' is not allowed for this method", null, null);
        }
        ArrayNode arrayNode = new ArrayNode(JsonNodeFactory.instance);
        if (Long.class.isAssignableFrom(type)) {
            attributeValue.forEach(t -> arrayNode.add((Long)t));
        } else if (Double.class.isAssignableFrom(type)) {
            attributeValue.forEach(t -> arrayNode.add((Double)t));
        } else if (Boolean.class.isAssignableFrom(type)) {
            attributeValue.forEach(t -> arrayNode.add((Boolean)t));
        } else if (byte[].class.isAssignableFrom(type)) {
            attributeValue.forEach(t -> arrayNode.add((byte[])t));
        } else {
            attributeValue.forEach(t -> arrayNode.add(t == null ? null : String.valueOf(t)));
        }
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)arrayNode);
    }

    protected <T extends JsonNode> void addAttribute(String attributeName, T attributeValue) {
        if (attributeValue == null) {
            return;
        }
        ArrayNode arrayNode = JsonHelper.getArrayAttribute((JsonNode)this, attributeName).orElse(new ArrayNode(JsonNodeFactory.instance));
        arrayNode.add(attributeValue);
        JsonHelper.addAttribute((JsonNode)this, attributeName, (JsonNode)arrayNode);
    }

    public String toString() {
        return JsonHelper.toJsonString((JsonNode)this);
    }

    public String toPrettyString() {
        return JsonHelper.toPrettyJsonString((JsonNode)this);
    }

    public boolean isEmpty() {
        return JsonHelper.isEmpty((JsonNode)this);
    }

    @Override
    public SchemaAttribute getSchemaAttribute() {
        return this.schemaAttribute;
    }
}

